/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.SmsCommandCreator;
import com.twilio.rest.supersim.v1.SmsCommandFetcher;
import com.twilio.rest.supersim.v1.SmsCommandReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SmsCommand
extends Resource {
    private static final long serialVersionUID = 38007963555299L;
    private final String sid;
    private final String accountSid;
    private final String simSid;
    private final String payload;
    private final Status status;
    private final Direction direction;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static SmsCommandCreator creator(String sim, String payload) {
        return new SmsCommandCreator(sim, payload);
    }

    public static SmsCommandFetcher fetcher(String pathSid) {
        return new SmsCommandFetcher(pathSid);
    }

    public static SmsCommandReader reader() {
        return new SmsCommandReader();
    }

    public static SmsCommand fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SmsCommand.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SmsCommand fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SmsCommand.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SmsCommand(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="payload") String payload, @JsonProperty(value="status") Status status, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.payload = payload;
        this.status = status;
        this.direction = direction;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getPayload() {
        return this.payload;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsCommand other = (SmsCommand)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.payload, other.payload) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.simSid, this.payload, this.status, this.direction, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "SmsCommand(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", simSid=" + this.getSimSid() + ", payload=" + this.getPayload() + ", status=" + (Object)((Object)this.getStatus()) + ", direction=" + (Object)((Object)this.getDirection()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        QUEUED("queued"),
        SENT("sent"),
        DELIVERED("delivered"),
        RECEIVED("received"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Direction {
        TO_SIM("to_sim"),
        FROM_SIM("from_sim");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            return (Direction)Promoter.enumFromString((String)value, (Enum[])Direction.values());
        }
    }
}

