/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.flow.FlowRevisionFetcher;
import com.twilio.rest.studio.v2.flow.FlowRevisionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FlowRevision
extends Resource {
    private static final long serialVersionUID = 84648223923809L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final Map<String, Object> definition;
    private final Status status;
    private final Integer revision;
    private final String commitMessage;
    private final Boolean valid;
    private final List<Map<String, Object>> errors;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static FlowRevisionFetcher fetcher(String pathSid, String pathRevision) {
        return new FlowRevisionFetcher(pathSid, pathRevision);
    }

    public static FlowRevisionReader reader(String pathSid) {
        return new FlowRevisionReader(pathSid);
    }

    public static FlowRevision fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlowRevision.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FlowRevision fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlowRevision.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FlowRevision(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="definition") Map<String, Object> definition, @JsonProperty(value="status") Status status, @JsonProperty(value="revision") Integer revision, @JsonProperty(value="commit_message") String commitMessage, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="errors") List<Map<String, Object>> errors, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.definition = definition;
        this.status = status;
        this.revision = revision;
        this.commitMessage = commitMessage;
        this.valid = valid;
        this.errors = errors;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, Object> getDefinition() {
        return this.definition;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Integer getRevision() {
        return this.revision;
    }

    public final String getCommitMessage() {
        return this.commitMessage;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowRevision other = (FlowRevision)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.definition, other.definition) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.revision, other.revision) && Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals(this.valid, other.valid) && Objects.equals(this.errors, other.errors) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.definition, this.status, this.revision, this.commitMessage, this.valid, this.errors, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "FlowRevision(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", definition=" + this.getDefinition() + ", status=" + (Object)((Object)this.getStatus()) + ", revision=" + this.getRevision() + ", commitMessage=" + this.getCommitMessage() + ", valid=" + this.getValid() + ", errors=" + this.getErrors() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PUBLISHED("published");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

