/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.Flow;
import java.util.Map;

public class FlowUpdater
extends Updater<Flow> {
    private String pathSid;
    private Flow.Status status;
    private String friendlyName;
    private Map<String, Object> definition;
    private String commitMessage;

    public FlowUpdater(String pathSid, Flow.Status status) {
        this.pathSid = pathSid;
        this.status = status;
    }

    public FlowUpdater setStatus(Flow.Status status) {
        this.status = status;
        return this;
    }

    public FlowUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FlowUpdater setDefinition(Map<String, Object> definition) {
        this.definition = definition;
        return this;
    }

    public FlowUpdater setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    @Override
    public Flow update(TwilioRestClient client) {
        String path = "/v2/Flows/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Status}", this.status.toString());
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Flow update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Flow.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.definition != null) {
            request.addPostParam("Definition", Converter.mapToJson(this.definition));
        }
        if (this.commitMessage != null) {
            request.addPostParam("CommitMessage", this.commitMessage);
        }
    }
}

