/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Execution;

public class ExecutionUpdater
extends Updater<Execution> {
    private String pathFlowSid;
    private String pathSid;
    private Execution.Status status;

    public ExecutionUpdater(String pathFlowSid, String pathSid, Execution.Status status) {
        this.pathFlowSid = pathFlowSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    public ExecutionUpdater setStatus(Execution.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Execution update(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Executions/{Sid}";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Status}", this.status.toString());
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Execution update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Execution.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

