/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.environment.VariableCreator;
import com.twilio.rest.serverless.v1.service.environment.VariableDeleter;
import com.twilio.rest.serverless.v1.service.environment.VariableFetcher;
import com.twilio.rest.serverless.v1.service.environment.VariableReader;
import com.twilio.rest.serverless.v1.service.environment.VariableUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Variable
extends Resource {
    private static final long serialVersionUID = 240706939520174L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String environmentSid;
    private final String key;
    private final String value;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static VariableCreator creator(String pathServiceSid, String pathEnvironmentSid, String key, String value) {
        return new VariableCreator(pathServiceSid, pathEnvironmentSid, key, value);
    }

    public static VariableDeleter deleter(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        return new VariableDeleter(pathServiceSid, pathEnvironmentSid, pathSid);
    }

    public static VariableFetcher fetcher(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        return new VariableFetcher(pathServiceSid, pathEnvironmentSid, pathSid);
    }

    public static VariableReader reader(String pathServiceSid, String pathEnvironmentSid) {
        return new VariableReader(pathServiceSid, pathEnvironmentSid);
    }

    public static VariableUpdater updater(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        return new VariableUpdater(pathServiceSid, pathEnvironmentSid, pathSid);
    }

    public static Variable fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Variable.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Variable fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Variable.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Variable(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="environment_sid") String environmentSid, @JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.environmentSid = environmentSid;
        this.key = key;
        this.value = value;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEnvironmentSid() {
        return this.environmentSid;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getValue() {
        return this.value;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable other = (Variable)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.environmentSid, other.environmentSid) && Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.environmentSid, this.key, this.value, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "Variable(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", environmentSid=" + this.getEnvironmentSid() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

