/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.asset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.asset.AssetVersionFetcher;
import com.twilio.rest.serverless.v1.service.asset.AssetVersionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetVersion
extends Resource {
    private static final long serialVersionUID = 215359401104297L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String assetSid;
    private final String path;
    private final Visibility visibility;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static AssetVersionFetcher fetcher(String pathServiceSid, String pathAssetSid, String pathSid) {
        return new AssetVersionFetcher(pathServiceSid, pathAssetSid, pathSid);
    }

    public static AssetVersionReader reader(String pathServiceSid, String pathAssetSid) {
        return new AssetVersionReader(pathServiceSid, pathAssetSid);
    }

    public static AssetVersion fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AssetVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AssetVersion fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AssetVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AssetVersion(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="asset_sid") String assetSid, @JsonProperty(value="path") String path, @JsonProperty(value="visibility") Visibility visibility, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.assetSid = assetSid;
        this.path = path;
        this.visibility = visibility;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAssetSid() {
        return this.assetSid;
    }

    public final String getPath() {
        return this.path;
    }

    public final Visibility getVisibility() {
        return this.visibility;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetVersion other = (AssetVersion)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.assetSid, other.assetSid) && Objects.equals(this.path, other.path) && Objects.equals((Object)this.visibility, (Object)other.visibility) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.assetSid, this.path, this.visibility, this.dateCreated, this.url});
    }

    public String toString() {
        return "AssetVersion(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", assetSid=" + this.getAssetSid() + ", path=" + this.getPath() + ", visibility=" + (Object)((Object)this.getVisibility()) + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Visibility {
        PUBLIC("public"),
        PRIVATE("private"),
        PROTECTED("protected");

        private final String value;

        private Visibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Visibility forValue(String value) {
            return (Visibility)Promoter.enumFromString((String)value, (Enum[])Visibility.values());
        }
    }
}

