/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.routes.v2.SipDomain;

public class SipDomainFetcher
extends Fetcher<SipDomain> {
    private String pathSipDomain;

    public SipDomainFetcher(String pathSipDomain) {
        this.pathSipDomain = pathSipDomain;
    }

    @Override
    public SipDomain fetch(TwilioRestClient client) {
        String path = "/v2/SipDomains/{SipDomain}";
        path = path.replace("{SipDomain}", this.pathSipDomain.toString());
        Request request = new Request(HttpMethod.GET, Domains.ROUTES.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SipDomain fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SipDomain.fromJson(response.getStream(), client.getObjectMapper());
    }
}

