/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.ShortCode;

public class ShortCodeReader
extends Reader<ShortCode> {
    private String pathServiceSid;
    private Integer pageSize;

    public ShortCodeReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public ShortCodeReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ShortCode> read(TwilioRestClient client) {
        return new ResourceSet<ShortCode>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ShortCode> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/ShortCodes";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PROXY.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<ShortCode> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ShortCode read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("short_codes", response.getContent(), ShortCode.class, client.getObjectMapper());
    }

    @Override
    public Page<ShortCode> previousPage(Page<ShortCode> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ShortCode> nextPage(Page<ShortCode> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ShortCode> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

