/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.ShortCode;

public class ShortCodeCreator
extends Creator<ShortCode> {
    private String pathServiceSid;
    private String sid;

    public ShortCodeCreator(String pathServiceSid, String sid) {
        this.pathServiceSid = pathServiceSid;
        this.sid = sid;
    }

    public ShortCodeCreator setSid(String sid) {
        this.sid = sid;
        return this;
    }

    @Override
    public ShortCode create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/ShortCodes";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Sid}", this.sid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ShortCode creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ShortCode.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sid != null) {
            request.addPostParam("Sid", this.sid);
        }
    }
}

