/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.Session;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

public class SessionCreator
extends Creator<Session> {
    private String pathServiceSid;
    private String uniqueName;
    private ZonedDateTime dateExpiry;
    private Integer ttl;
    private Session.Mode mode;
    private Session.Status status;
    private List<Map<String, Object>> participants;

    public SessionCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SessionCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public SessionCreator setDateExpiry(ZonedDateTime dateExpiry) {
        this.dateExpiry = dateExpiry;
        return this;
    }

    public SessionCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SessionCreator setMode(Session.Mode mode) {
        this.mode = mode;
        return this;
    }

    public SessionCreator setStatus(Session.Status status) {
        this.status = status;
        return this;
    }

    public SessionCreator setParticipants(List<Map<String, Object>> participants) {
        this.participants = participants;
        return this;
    }

    public SessionCreator setParticipants(Map<String, Object> participants) {
        return this.setParticipants(Promoter.listOfOne(participants));
    }

    @Override
    public Session create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Sessions";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Session creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Session.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.dateExpiry != null) {
            request.addPostParam("DateExpiry", this.dateExpiry.toInstant().toString());
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.mode != null) {
            request.addPostParam("Mode", this.mode.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.participants != null) {
            for (Map<String, Object> prop : this.participants) {
                request.addPostParam("Participants", Converter.mapToJson(prop));
            }
        }
    }
}

