/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.service.SessionCreator;
import com.twilio.rest.proxy.v1.service.SessionDeleter;
import com.twilio.rest.proxy.v1.service.SessionFetcher;
import com.twilio.rest.proxy.v1.service.SessionReader;
import com.twilio.rest.proxy.v1.service.SessionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Session
extends Resource {
    private static final long serialVersionUID = 86537474068288L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final ZonedDateTime dateStarted;
    private final ZonedDateTime dateEnded;
    private final ZonedDateTime dateLastInteraction;
    private final ZonedDateTime dateExpiry;
    private final String uniqueName;
    private final Status status;
    private final String closedReason;
    private final Integer ttl;
    private final Mode mode;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static SessionCreator creator(String pathServiceSid) {
        return new SessionCreator(pathServiceSid);
    }

    public static SessionDeleter deleter(String pathServiceSid, String pathSid) {
        return new SessionDeleter(pathServiceSid, pathSid);
    }

    public static SessionFetcher fetcher(String pathServiceSid, String pathSid) {
        return new SessionFetcher(pathServiceSid, pathSid);
    }

    public static SessionReader reader(String pathServiceSid) {
        return new SessionReader(pathServiceSid);
    }

    public static SessionUpdater updater(String pathServiceSid, String pathSid) {
        return new SessionUpdater(pathServiceSid, pathSid);
    }

    public static Session fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Session.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Session fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Session.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Session(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_started") String dateStarted, @JsonProperty(value="date_ended") String dateEnded, @JsonProperty(value="date_last_interaction") String dateLastInteraction, @JsonProperty(value="date_expiry") String dateExpiry, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="status") Status status, @JsonProperty(value="closed_reason") String closedReason, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="mode") Mode mode, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.dateStarted = DateConverter.iso8601DateTimeFromString(dateStarted);
        this.dateEnded = DateConverter.iso8601DateTimeFromString(dateEnded);
        this.dateLastInteraction = DateConverter.iso8601DateTimeFromString(dateLastInteraction);
        this.dateExpiry = DateConverter.iso8601DateTimeFromString(dateExpiry);
        this.uniqueName = uniqueName;
        this.status = status;
        this.closedReason = closedReason;
        this.ttl = ttl;
        this.mode = mode;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final ZonedDateTime getDateStarted() {
        return this.dateStarted;
    }

    public final ZonedDateTime getDateEnded() {
        return this.dateEnded;
    }

    public final ZonedDateTime getDateLastInteraction() {
        return this.dateLastInteraction;
    }

    public final ZonedDateTime getDateExpiry() {
        return this.dateExpiry;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getClosedReason() {
        return this.closedReason;
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session other = (Session)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateStarted, other.dateStarted) && Objects.equals(this.dateEnded, other.dateEnded) && Objects.equals(this.dateLastInteraction, other.dateLastInteraction) && Objects.equals(this.dateExpiry, other.dateExpiry) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.closedReason, other.closedReason) && Objects.equals(this.ttl, other.ttl) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.serviceSid, this.accountSid, this.dateStarted, this.dateEnded, this.dateLastInteraction, this.dateExpiry, this.uniqueName, this.status, this.closedReason, this.ttl, this.mode, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return "Session(sid=" + this.getSid() + ", serviceSid=" + this.getServiceSid() + ", accountSid=" + this.getAccountSid() + ", dateStarted=" + this.getDateStarted() + ", dateEnded=" + this.getDateEnded() + ", dateLastInteraction=" + this.getDateLastInteraction() + ", dateExpiry=" + this.getDateExpiry() + ", uniqueName=" + this.getUniqueName() + ", status=" + (Object)((Object)this.getStatus()) + ", closedReason=" + this.getClosedReason() + ", ttl=" + this.getTtl() + ", mode=" + (Object)((Object)this.getMode()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        OPEN("open"),
        IN_PROGRESS("in-progress"),
        CLOSED("closed"),
        FAILED("failed"),
        UNKNOWN("unknown");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Mode {
        MESSAGE_ONLY("message-only"),
        VOICE_ONLY("voice-only"),
        VOICE_AND_MESSAGE("voice-and-message");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Mode forValue(String value) {
            return (Mode)Promoter.enumFromString((String)value, (Enum[])Mode.values());
        }
    }
}

