/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v2.voice;

import com.twilio.base.Fetcher;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.pricing.v2.voice.Number;
import com.twilio.type.PhoneNumber;

public class NumberFetcher
extends Fetcher<Number> {
    private PhoneNumber pathDestinationNumber;
    private PhoneNumber originationNumber;

    public NumberFetcher(PhoneNumber pathDestinationNumber) {
        this.pathDestinationNumber = pathDestinationNumber;
    }

    public NumberFetcher setOriginationNumber(PhoneNumber originationNumber) {
        this.originationNumber = originationNumber;
        return this;
    }

    public NumberFetcher setOriginationNumber(String originationNumber) {
        return this.setOriginationNumber(Promoter.phoneNumberFromString(originationNumber));
    }

    @Override
    public Number fetch(TwilioRestClient client) {
        String path = "/v2/Voice/Numbers/{DestinationNumber}";
        path = path.replace("{DestinationNumber}", this.pathDestinationNumber.encode("utf-8"));
        Request request = new Request(HttpMethod.GET, Domains.PRICING.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Number fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Number.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.originationNumber != null) {
            request.addQueryParam("OriginationNumber", this.originationNumber.toString());
        }
    }
}

