/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewmessaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.previewmessaging.v1.MessageCreator;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 198419191205133L;
    private final Integer totalMessageCount;
    private final Integer successCount;
    private final Integer errorCount;
    private final List<MessagingV1MessageReceipt> messageReceipts;
    private final List<MessagingV1FailedMessageReceipt> failedMessageReceipts;

    public static MessageCreator creator(CreateMessagesRequest createMessagesRequest) {
        return new MessageCreator(createMessagesRequest);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="total_message_count") Integer totalMessageCount, @JsonProperty(value="success_count") Integer successCount, @JsonProperty(value="error_count") Integer errorCount, @JsonProperty(value="message_receipts") List<MessagingV1MessageReceipt> messageReceipts, @JsonProperty(value="failed_message_receipts") List<MessagingV1FailedMessageReceipt> failedMessageReceipts) {
        this.totalMessageCount = totalMessageCount;
        this.successCount = successCount;
        this.errorCount = errorCount;
        this.messageReceipts = messageReceipts;
        this.failedMessageReceipts = failedMessageReceipts;
    }

    public final Integer getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public final Integer getSuccessCount() {
        return this.successCount;
    }

    public final Integer getErrorCount() {
        return this.errorCount;
    }

    public final List<MessagingV1MessageReceipt> getMessageReceipts() {
        return this.messageReceipts;
    }

    public final List<MessagingV1FailedMessageReceipt> getFailedMessageReceipts() {
        return this.failedMessageReceipts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.totalMessageCount, other.totalMessageCount) && Objects.equals(this.successCount, other.successCount) && Objects.equals(this.errorCount, other.errorCount) && Objects.equals(this.messageReceipts, other.messageReceipts) && Objects.equals(this.failedMessageReceipts, other.failedMessageReceipts);
    }

    public int hashCode() {
        return Objects.hash(this.totalMessageCount, this.successCount, this.errorCount, this.messageReceipts, this.failedMessageReceipts);
    }

    public String toString() {
        return "Message(totalMessageCount=" + this.getTotalMessageCount() + ", successCount=" + this.getSuccessCount() + ", errorCount=" + this.getErrorCount() + ", messageReceipts=" + this.getMessageReceipts() + ", failedMessageReceipts=" + this.getFailedMessageReceipts() + ")";
    }

    public static class MessagingV1FailedMessageReceipt {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="to")
        private String to;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="error_message")
        private String errorMessage;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="error_code")
        private Integer errorCode;

        public static MessagingV1FailedMessageReceipt fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, MessagingV1FailedMessageReceipt.class);
        }

        public String toString() {
            return "Message.MessagingV1FailedMessageReceipt(to=" + this.getTo() + ", errorMessage=" + this.getErrorMessage() + ", errorCode=" + this.getErrorCode() + ")";
        }

        public String getTo() {
            return this.to;
        }

        @JsonProperty(value="to")
        public void setTo(String to) {
            this.to = to;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        @JsonProperty(value="error_message")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        @JsonProperty(value="error_code")
        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static class MessagingV1MessageReceipt {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="to")
        private String to;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="sid")
        private String sid;

        public static MessagingV1MessageReceipt fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, MessagingV1MessageReceipt.class);
        }

        public String toString() {
            return "Message.MessagingV1MessageReceipt(to=" + this.getTo() + ", sid=" + this.getSid() + ")";
        }

        public String getTo() {
            return this.to;
        }

        @JsonProperty(value="to")
        public void setTo(String to) {
            this.to = to;
        }

        public String getSid() {
            return this.sid;
        }

        @JsonProperty(value="sid")
        public void setSid(String sid) {
            this.sid = sid;
        }
    }

    public static class CreateMessagesRequest {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="Messages")
        private List<MessagingV1Message> messages;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="From")
        private PhoneNumber from;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="MessagingServiceSid")
        private String messagingServiceSid;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="Body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ContentSid")
        private String contentSid;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="MediaUrl")
        private List<URI> mediaUrl;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="StatusCallback")
        private URI statusCallback;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ValidityPeriod")
        private Integer validityPeriod;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="SendAt")
        private String sendAt;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ScheduleType")
        private String scheduleType;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ShortenUrls")
        private Boolean shortenUrls;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="SendAsMms")
        private Boolean sendAsMms;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="MaxPrice")
        private BigDecimal maxPrice;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="Attempt")
        private Integer attempt;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="SmartEncoded")
        private Boolean smartEncoded;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ForceDelivery")
        private Boolean forceDelivery;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ApplicationSid")
        private String applicationSid;

        public String getFrom() {
            return this.from.getEndpoint();
        }

        public static CreateMessagesRequest fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, CreateMessagesRequest.class);
        }

        public String toString() {
            return "Message.CreateMessagesRequest(messages=" + this.getMessages() + ", from=" + this.getFrom() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", body=" + this.getBody() + ", contentSid=" + this.getContentSid() + ", mediaUrl=" + this.getMediaUrl() + ", statusCallback=" + this.getStatusCallback() + ", validityPeriod=" + this.getValidityPeriod() + ", sendAt=" + this.getSendAt() + ", scheduleType=" + this.getScheduleType() + ", shortenUrls=" + this.getShortenUrls() + ", sendAsMms=" + this.getSendAsMms() + ", maxPrice=" + this.getMaxPrice() + ", attempt=" + this.getAttempt() + ", smartEncoded=" + this.getSmartEncoded() + ", forceDelivery=" + this.getForceDelivery() + ", applicationSid=" + this.getApplicationSid() + ")";
        }

        public List<MessagingV1Message> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="Messages")
        public void setMessages(List<MessagingV1Message> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="From")
        public void setFrom(PhoneNumber from) {
            this.from = from;
        }

        public String getMessagingServiceSid() {
            return this.messagingServiceSid;
        }

        @JsonProperty(value="MessagingServiceSid")
        public void setMessagingServiceSid(String messagingServiceSid) {
            this.messagingServiceSid = messagingServiceSid;
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="Body")
        public void setBody(String body) {
            this.body = body;
        }

        public String getContentSid() {
            return this.contentSid;
        }

        @JsonProperty(value="ContentSid")
        public void setContentSid(String contentSid) {
            this.contentSid = contentSid;
        }

        public List<URI> getMediaUrl() {
            return this.mediaUrl;
        }

        @JsonProperty(value="MediaUrl")
        public void setMediaUrl(List<URI> mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public URI getStatusCallback() {
            return this.statusCallback;
        }

        @JsonProperty(value="StatusCallback")
        public void setStatusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
        }

        public Integer getValidityPeriod() {
            return this.validityPeriod;
        }

        @JsonProperty(value="ValidityPeriod")
        public void setValidityPeriod(Integer validityPeriod) {
            this.validityPeriod = validityPeriod;
        }

        public String getSendAt() {
            return this.sendAt;
        }

        @JsonProperty(value="SendAt")
        public void setSendAt(String sendAt) {
            this.sendAt = sendAt;
        }

        public String getScheduleType() {
            return this.scheduleType;
        }

        @JsonProperty(value="ScheduleType")
        public void setScheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
        }

        public Boolean getShortenUrls() {
            return this.shortenUrls;
        }

        @JsonProperty(value="ShortenUrls")
        public void setShortenUrls(Boolean shortenUrls) {
            this.shortenUrls = shortenUrls;
        }

        public Boolean getSendAsMms() {
            return this.sendAsMms;
        }

        @JsonProperty(value="SendAsMms")
        public void setSendAsMms(Boolean sendAsMms) {
            this.sendAsMms = sendAsMms;
        }

        public BigDecimal getMaxPrice() {
            return this.maxPrice;
        }

        @JsonProperty(value="MaxPrice")
        public void setMaxPrice(BigDecimal maxPrice) {
            this.maxPrice = maxPrice;
        }

        public Integer getAttempt() {
            return this.attempt;
        }

        @JsonProperty(value="Attempt")
        public void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public Boolean getSmartEncoded() {
            return this.smartEncoded;
        }

        @JsonProperty(value="SmartEncoded")
        public void setSmartEncoded(Boolean smartEncoded) {
            this.smartEncoded = smartEncoded;
        }

        public Boolean getForceDelivery() {
            return this.forceDelivery;
        }

        @JsonProperty(value="ForceDelivery")
        public void setForceDelivery(Boolean forceDelivery) {
            this.forceDelivery = forceDelivery;
        }

        public String getApplicationSid() {
            return this.applicationSid;
        }

        @JsonProperty(value="ApplicationSid")
        public void setApplicationSid(String applicationSid) {
            this.applicationSid = applicationSid;
        }
    }

    public static class MessagingV1Message {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="To")
        private PhoneNumber to;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="Body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="ContentVariables")
        private Map<String, String> contentVariables;

        public String getTo() {
            return this.to.getEndpoint();
        }

        public static MessagingV1Message fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, MessagingV1Message.class);
        }

        public String toString() {
            return "Message.MessagingV1Message(to=" + this.getTo() + ", body=" + this.getBody() + ", contentVariables=" + this.getContentVariables() + ")";
        }

        @JsonProperty(value="To")
        public void setTo(PhoneNumber to) {
            this.to = to;
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="Body")
        public void setBody(String body) {
            this.body = body;
        }

        public Map<String, String> getContentVariables() {
            return this.contentVariables;
        }

        @JsonProperty(value="ContentVariables")
        public void setContentVariables(Map<String, String> contentVariables) {
            this.contentVariables = contentVariables;
        }
    }
}

