/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewmessaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.previewmessaging.v1.BroadcastCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Broadcast
extends Resource {
    private static final long serialVersionUID = 4228754680541L;
    private final String broadcastSid;
    private final ZonedDateTime createdDate;
    private final ZonedDateTime updatedDate;
    private final String broadcastStatus;
    private final MessagingV1BroadcastExecutionDetails executionDetails;
    private final URI resultsFile;

    public static BroadcastCreator creator() {
        return new BroadcastCreator();
    }

    public static Broadcast fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Broadcast.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Broadcast fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Broadcast.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Broadcast(@JsonProperty(value="broadcast_sid") String broadcastSid, @JsonProperty(value="created_date") String createdDate, @JsonProperty(value="updated_date") String updatedDate, @JsonProperty(value="broadcast_status") String broadcastStatus, @JsonProperty(value="execution_details") MessagingV1BroadcastExecutionDetails executionDetails, @JsonProperty(value="results_file") URI resultsFile) {
        this.broadcastSid = broadcastSid;
        this.createdDate = DateConverter.iso8601DateTimeFromString(createdDate);
        this.updatedDate = DateConverter.iso8601DateTimeFromString(updatedDate);
        this.broadcastStatus = broadcastStatus;
        this.executionDetails = executionDetails;
        this.resultsFile = resultsFile;
    }

    public final String getBroadcastSid() {
        return this.broadcastSid;
    }

    public final ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public final ZonedDateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public final String getBroadcastStatus() {
        return this.broadcastStatus;
    }

    public final MessagingV1BroadcastExecutionDetails getExecutionDetails() {
        return this.executionDetails;
    }

    public final URI getResultsFile() {
        return this.resultsFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Broadcast other = (Broadcast)o;
        return Objects.equals(this.broadcastSid, other.broadcastSid) && Objects.equals(this.createdDate, other.createdDate) && Objects.equals(this.updatedDate, other.updatedDate) && Objects.equals(this.broadcastStatus, other.broadcastStatus) && Objects.equals(this.executionDetails, other.executionDetails) && Objects.equals(this.resultsFile, other.resultsFile);
    }

    public int hashCode() {
        return Objects.hash(this.broadcastSid, this.createdDate, this.updatedDate, this.broadcastStatus, this.executionDetails, this.resultsFile);
    }

    public String toString() {
        return "Broadcast(broadcastSid=" + this.getBroadcastSid() + ", createdDate=" + this.getCreatedDate() + ", updatedDate=" + this.getUpdatedDate() + ", broadcastStatus=" + this.getBroadcastStatus() + ", executionDetails=" + this.getExecutionDetails() + ", resultsFile=" + this.getResultsFile() + ")";
    }

    public static class MessagingV1BroadcastExecutionDetails {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="total_records")
        private Integer totalRecords;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="total_completed")
        private Integer totalCompleted;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="total_errors")
        private Integer totalErrors;

        public static MessagingV1BroadcastExecutionDetails fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, MessagingV1BroadcastExecutionDetails.class);
        }

        public String toString() {
            return "Broadcast.MessagingV1BroadcastExecutionDetails(totalRecords=" + this.getTotalRecords() + ", totalCompleted=" + this.getTotalCompleted() + ", totalErrors=" + this.getTotalErrors() + ")";
        }

        public Integer getTotalRecords() {
            return this.totalRecords;
        }

        @JsonProperty(value="total_records")
        public void setTotalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
        }

        public Integer getTotalCompleted() {
            return this.totalCompleted;
        }

        @JsonProperty(value="total_completed")
        public void setTotalCompleted(Integer totalCompleted) {
            this.totalCompleted = totalCompleted;
        }

        public Integer getTotalErrors() {
            return this.totalErrors;
        }

        @JsonProperty(value="total_errors")
        public void setTotalErrors(Integer totalErrors) {
            this.totalErrors = totalErrors;
        }
    }
}

