/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.document;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.sync.service.document.DocumentPermissionDeleter;
import com.twilio.rest.preview.sync.service.document.DocumentPermissionFetcher;
import com.twilio.rest.preview.sync.service.document.DocumentPermissionReader;
import com.twilio.rest.preview.sync.service.document.DocumentPermissionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DocumentPermission
extends Resource {
    private static final long serialVersionUID = 90173038651529L;
    private final String accountSid;
    private final String serviceSid;
    private final String documentSid;
    private final String identity;
    private final Boolean read;
    private final Boolean write;
    private final Boolean manage;
    private final URI url;

    public static DocumentPermissionDeleter deleter(String pathServiceSid, String pathDocumentSid, String pathIdentity) {
        return new DocumentPermissionDeleter(pathServiceSid, pathDocumentSid, pathIdentity);
    }

    public static DocumentPermissionFetcher fetcher(String pathServiceSid, String pathDocumentSid, String pathIdentity) {
        return new DocumentPermissionFetcher(pathServiceSid, pathDocumentSid, pathIdentity);
    }

    public static DocumentPermissionReader reader(String pathServiceSid, String pathDocumentSid) {
        return new DocumentPermissionReader(pathServiceSid, pathDocumentSid);
    }

    public static DocumentPermissionUpdater updater(String pathServiceSid, String pathDocumentSid, String pathIdentity, Boolean read, Boolean write, Boolean manage) {
        return new DocumentPermissionUpdater(pathServiceSid, pathDocumentSid, pathIdentity, read, write, manage);
    }

    public static DocumentPermission fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DocumentPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DocumentPermission fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DocumentPermission.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DocumentPermission(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="document_sid") String documentSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="read") Boolean read, @JsonProperty(value="write") Boolean write, @JsonProperty(value="manage") Boolean manage, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.documentSid = documentSid;
        this.identity = identity;
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getDocumentSid() {
        return this.documentSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Boolean getRead() {
        return this.read;
    }

    public final Boolean getWrite() {
        return this.write;
    }

    public final Boolean getManage() {
        return this.manage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPermission other = (DocumentPermission)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.documentSid, other.documentSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.read, other.read) && Objects.equals(this.write, other.write) && Objects.equals(this.manage, other.manage) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.serviceSid, this.documentSid, this.identity, this.read, this.write, this.manage, this.url);
    }

    public String toString() {
        return "DocumentPermission(accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", documentSid=" + this.getDocumentSid() + ", identity=" + this.getIdentity() + ", read=" + this.getRead() + ", write=" + this.getWrite() + ", manage=" + this.getManage() + ", url=" + this.getUrl() + ")";
    }
}

