/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.marketplace.InstalledAddOn;

public class InstalledAddOnReader
extends Reader<InstalledAddOn> {
    private Integer pageSize;

    public InstalledAddOnReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<InstalledAddOn> read(TwilioRestClient client) {
        return new ResourceSet<InstalledAddOn>(this, client, this.firstPage(client));
    }

    @Override
    public Page<InstalledAddOn> firstPage(TwilioRestClient client) {
        String path = "/marketplace/InstalledAddOns";
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<InstalledAddOn> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOn read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("installed_add_ons", response.getContent(), InstalledAddOn.class, client.getObjectMapper());
    }

    @Override
    public Page<InstalledAddOn> previousPage(Page<InstalledAddOn> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InstalledAddOn> nextPage(Page<InstalledAddOn> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InstalledAddOn> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

