/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocument;
import java.util.List;

public class AuthorizationDocumentUpdater
extends Updater<AuthorizationDocument> {
    private String pathSid;
    private List<String> hostedNumberOrderSids;
    private String addressSid;
    private String email;
    private List<String> ccEmails;
    private AuthorizationDocument.Status status;
    private String contactTitle;
    private String contactPhoneNumber;

    public AuthorizationDocumentUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public AuthorizationDocumentUpdater setHostedNumberOrderSids(List<String> hostedNumberOrderSids) {
        this.hostedNumberOrderSids = hostedNumberOrderSids;
        return this;
    }

    public AuthorizationDocumentUpdater setHostedNumberOrderSids(String hostedNumberOrderSids) {
        return this.setHostedNumberOrderSids(Promoter.listOfOne(hostedNumberOrderSids));
    }

    public AuthorizationDocumentUpdater setAddressSid(String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    public AuthorizationDocumentUpdater setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthorizationDocumentUpdater setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public AuthorizationDocumentUpdater setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    public AuthorizationDocumentUpdater setStatus(AuthorizationDocument.Status status) {
        this.status = status;
        return this;
    }

    public AuthorizationDocumentUpdater setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
        return this;
    }

    public AuthorizationDocumentUpdater setContactPhoneNumber(String contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
        return this;
    }

    @Override
    public AuthorizationDocument update(TwilioRestClient client) {
        String path = "/HostedNumbers/AuthorizationDocuments/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AuthorizationDocument.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.hostedNumberOrderSids != null) {
            for (String prop : this.hostedNumberOrderSids) {
                request.addPostParam("HostedNumberOrderSids", prop);
            }
        }
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.contactTitle != null) {
            request.addPostParam("ContactTitle", this.contactTitle);
        }
        if (this.contactPhoneNumber != null) {
            request.addPostParam("ContactPhoneNumber", this.contactPhoneNumber);
        }
    }
}

