/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.deployedDevices.fleet.DeviceCreator;
import com.twilio.rest.preview.deployedDevices.fleet.DeviceDeleter;
import com.twilio.rest.preview.deployedDevices.fleet.DeviceFetcher;
import com.twilio.rest.preview.deployedDevices.fleet.DeviceReader;
import com.twilio.rest.preview.deployedDevices.fleet.DeviceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Device
extends Resource {
    private static final long serialVersionUID = 204948181343163L;
    private final String sid;
    private final URI url;
    private final String uniqueName;
    private final String friendlyName;
    private final String fleetSid;
    private final Boolean enabled;
    private final String accountSid;
    private final String identity;
    private final String deploymentSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateAuthenticated;

    public static DeviceCreator creator(String pathFleetSid) {
        return new DeviceCreator(pathFleetSid);
    }

    public static DeviceDeleter deleter(String pathFleetSid, String pathSid) {
        return new DeviceDeleter(pathFleetSid, pathSid);
    }

    public static DeviceFetcher fetcher(String pathFleetSid, String pathSid) {
        return new DeviceFetcher(pathFleetSid, pathSid);
    }

    public static DeviceReader reader(String pathFleetSid) {
        return new DeviceReader(pathFleetSid);
    }

    public static DeviceUpdater updater(String pathFleetSid, String pathSid) {
        return new DeviceUpdater(pathFleetSid, pathSid);
    }

    public static Device fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Device fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Device(@JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="deployment_sid") String deploymentSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_authenticated") String dateAuthenticated) {
        this.sid = sid;
        this.url = url;
        this.uniqueName = uniqueName;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.enabled = enabled;
        this.accountSid = accountSid;
        this.identity = identity;
        this.deploymentSid = deploymentSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateAuthenticated = DateConverter.iso8601DateTimeFromString(dateAuthenticated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getDeploymentSid() {
        return this.deploymentSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateAuthenticated() {
        return this.dateAuthenticated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device other = (Device)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.deploymentSid, other.deploymentSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateAuthenticated, other.dateAuthenticated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.url, this.uniqueName, this.friendlyName, this.fleetSid, this.enabled, this.accountSid, this.identity, this.deploymentSid, this.dateCreated, this.dateUpdated, this.dateAuthenticated);
    }

    public String toString() {
        return "Device(sid=" + this.getSid() + ", url=" + this.getUrl() + ", uniqueName=" + this.getUniqueName() + ", friendlyName=" + this.getFriendlyName() + ", fleetSid=" + this.getFleetSid() + ", enabled=" + this.getEnabled() + ", accountSid=" + this.getAccountSid() + ", identity=" + this.getIdentity() + ", deploymentSid=" + this.getDeploymentSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", dateAuthenticated=" + this.getDateAuthenticated() + ")";
    }
}

