/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ReplaceItemsCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReplaceItems
extends Resource {
    private static final long serialVersionUID = 154268646541269L;
    private final String sid;
    private final String accountSid;
    private final String regulationSid;
    private final String friendlyName;
    private final Status status;
    private final ZonedDateTime validUntil;
    private final String email;
    private final URI statusCallback;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static ReplaceItemsCreator creator(String pathBundleSid, String fromBundleSid) {
        return new ReplaceItemsCreator(pathBundleSid, fromBundleSid);
    }

    public static ReplaceItems fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ReplaceItems.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ReplaceItems fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ReplaceItems.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ReplaceItems(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="regulation_sid") String regulationSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") Status status, @JsonProperty(value="valid_until") String validUntil, @JsonProperty(value="email") String email, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.regulationSid = regulationSid;
        this.friendlyName = friendlyName;
        this.status = status;
        this.validUntil = DateConverter.iso8601DateTimeFromString(validUntil);
        this.email = email;
        this.statusCallback = statusCallback;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRegulationSid() {
        return this.regulationSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceItems other = (ReplaceItems)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.regulationSid, other.regulationSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.validUntil, other.validUntil) && Objects.equals(this.email, other.email) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.regulationSid, this.friendlyName, this.status, this.validUntil, this.email, this.statusCallback, this.dateCreated, this.dateUpdated});
    }

    public String toString() {
        return "ReplaceItems(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", regulationSid=" + this.getRegulationSid() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", validUntil=" + this.getValidUntil() + ", email=" + this.getEmail() + ", statusCallback=" + this.getStatusCallback() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PENDING_REVIEW("pending-review"),
        IN_REVIEW("in-review"),
        TWILIO_REJECTED("twilio-rejected"),
        TWILIO_APPROVED("twilio-approved"),
        PROVISIONALLY_APPROVED("provisionally-approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

