/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignment;

public class ItemAssignmentCreator
extends Creator<ItemAssignment> {
    private String pathBundleSid;
    private String objectSid;

    public ItemAssignmentCreator(String pathBundleSid, String objectSid) {
        this.pathBundleSid = pathBundleSid;
        this.objectSid = objectSid;
    }

    public ItemAssignmentCreator setObjectSid(String objectSid) {
        this.objectSid = objectSid;
        return this;
    }

    @Override
    public ItemAssignment create(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Bundles/{BundleSid}/ItemAssignments";
        path = path.replace("{BundleSid}", this.pathBundleSid.toString());
        path = path.replace("{ObjectSid}", this.objectSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ItemAssignment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ItemAssignment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.objectSid != null) {
            request.addPostParam("ObjectSid", this.objectSid);
        }
    }
}

