/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.Evaluation;

public class EvaluationFetcher
extends Fetcher<Evaluation> {
    private String pathBundleSid;
    private String pathSid;

    public EvaluationFetcher(String pathBundleSid, String pathSid) {
        this.pathBundleSid = pathBundleSid;
        this.pathSid = pathSid;
    }

    @Override
    public Evaluation fetch(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Bundles/{BundleSid}/Evaluations/{Sid}";
        path = path.replace("{BundleSid}", this.pathBundleSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Evaluation fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Evaluation.fromJson(response.getStream(), client.getObjectMapper());
    }
}

