/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.HostedNumberOrder;
import com.twilio.type.PhoneNumber;
import java.net.URI;
import java.util.List;

public class HostedNumberOrderCreator
extends Creator<HostedNumberOrder> {
    private PhoneNumber phoneNumber;
    private PhoneNumber contactPhoneNumber;
    private String addressSid;
    private String email;
    private String accountSid;
    private String friendlyName;
    private List<String> ccEmails;
    private URI smsUrl;
    private HttpMethod smsMethod;
    private URI smsFallbackUrl;
    private Boolean smsCapability;
    private HttpMethod smsFallbackMethod;
    private URI statusCallbackUrl;
    private HttpMethod statusCallbackMethod;
    private String smsApplicationSid;
    private String contactTitle;

    public HostedNumberOrderCreator(PhoneNumber phoneNumber, PhoneNumber contactPhoneNumber, String addressSid, String email) {
        this.phoneNumber = phoneNumber;
        this.contactPhoneNumber = contactPhoneNumber;
        this.addressSid = addressSid;
        this.email = email;
    }

    public HostedNumberOrderCreator setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public HostedNumberOrderCreator setPhoneNumber(String phoneNumber) {
        return this.setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    public HostedNumberOrderCreator setContactPhoneNumber(PhoneNumber contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
        return this;
    }

    public HostedNumberOrderCreator setContactPhoneNumber(String contactPhoneNumber) {
        return this.setContactPhoneNumber(Promoter.phoneNumberFromString(contactPhoneNumber));
    }

    public HostedNumberOrderCreator setAddressSid(String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    public HostedNumberOrderCreator setEmail(String email) {
        this.email = email;
        return this;
    }

    public HostedNumberOrderCreator setAccountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    public HostedNumberOrderCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public HostedNumberOrderCreator setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public HostedNumberOrderCreator setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    public HostedNumberOrderCreator setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public HostedNumberOrderCreator setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public HostedNumberOrderCreator setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public HostedNumberOrderCreator setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public HostedNumberOrderCreator setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public HostedNumberOrderCreator setSmsCapability(Boolean smsCapability) {
        this.smsCapability = smsCapability;
        return this;
    }

    public HostedNumberOrderCreator setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    public HostedNumberOrderCreator setStatusCallbackUrl(URI statusCallbackUrl) {
        this.statusCallbackUrl = statusCallbackUrl;
        return this;
    }

    public HostedNumberOrderCreator setStatusCallbackUrl(String statusCallbackUrl) {
        return this.setStatusCallbackUrl(Promoter.uriFromString(statusCallbackUrl));
    }

    public HostedNumberOrderCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public HostedNumberOrderCreator setSmsApplicationSid(String smsApplicationSid) {
        this.smsApplicationSid = smsApplicationSid;
        return this;
    }

    public HostedNumberOrderCreator setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
        return this;
    }

    @Override
    public HostedNumberOrder create(TwilioRestClient client) {
        String path = "/v2/HostedNumber/Orders";
        path = path.replace("{PhoneNumber}", this.phoneNumber.encode("utf-8"));
        path = path.replace("{ContactPhoneNumber}", this.contactPhoneNumber.encode("utf-8"));
        path = path.replace("{AddressSid}", this.addressSid.toString());
        path = path.replace("{Email}", this.email.toString());
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("HostedNumberOrder creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return HostedNumberOrder.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumber != null) {
            request.addPostParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.contactPhoneNumber != null) {
            request.addPostParam("ContactPhoneNumber", this.contactPhoneNumber.toString());
        }
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.accountSid != null) {
            request.addPostParam("AccountSid", this.accountSid);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsCapability != null) {
            request.addPostParam("SmsCapability", this.smsCapability.toString());
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
        if (this.statusCallbackUrl != null) {
            request.addPostParam("StatusCallbackUrl", this.statusCallbackUrl.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.smsApplicationSid != null) {
            request.addPostParam("SmsApplicationSid", this.smsApplicationSid);
        }
        if (this.contactTitle != null) {
            request.addPostParam("ContactTitle", this.contactTitle);
        }
    }
}

