/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.HostedNumberOrderCreator;
import com.twilio.rest.numbers.v2.HostedNumberOrderDeleter;
import com.twilio.rest.numbers.v2.HostedNumberOrderFetcher;
import com.twilio.rest.numbers.v2.HostedNumberOrderReader;
import com.twilio.type.PhoneNumber;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostedNumberOrder
extends Resource {
    private static final long serialVersionUID = 181489495524580L;
    private final String sid;
    private final String accountSid;
    private final String incomingPhoneNumberSid;
    private final String addressSid;
    private final String signingDocumentSid;
    private final PhoneNumber phoneNumber;
    private final PhoneNumberCapabilities capabilities;
    private final String friendlyName;
    private final Status status;
    private final String failureReason;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String email;
    private final List<String> ccEmails;
    private final URI url;
    private final String contactTitle;
    private final PhoneNumber contactPhoneNumber;
    private final String bulkHostingRequestSid;
    private final String nextStep;

    public static HostedNumberOrderCreator creator(PhoneNumber phoneNumber, PhoneNumber contactPhoneNumber, String addressSid, String email) {
        return new HostedNumberOrderCreator(phoneNumber, contactPhoneNumber, addressSid, email);
    }

    public static HostedNumberOrderDeleter deleter(String pathSid) {
        return new HostedNumberOrderDeleter(pathSid);
    }

    public static HostedNumberOrderFetcher fetcher(String pathSid) {
        return new HostedNumberOrderFetcher(pathSid);
    }

    public static HostedNumberOrderReader reader() {
        return new HostedNumberOrderReader();
    }

    public static HostedNumberOrder fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, HostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static HostedNumberOrder fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, HostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private HostedNumberOrder(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="incoming_phone_number_sid") String incomingPhoneNumberSid, @JsonProperty(value="address_sid") String addressSid, @JsonProperty(value="signing_document_sid") String signingDocumentSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") Status status, @JsonProperty(value="failure_reason") String failureReason, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="email") String email, @JsonProperty(value="cc_emails") List<String> ccEmails, @JsonProperty(value="url") URI url, @JsonProperty(value="contact_title") String contactTitle, @JsonProperty(value="contact_phone_number") PhoneNumber contactPhoneNumber, @JsonProperty(value="bulk_hosting_request_sid") String bulkHostingRequestSid, @JsonProperty(value="next_step") String nextStep) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.incomingPhoneNumberSid = incomingPhoneNumberSid;
        this.addressSid = addressSid;
        this.signingDocumentSid = signingDocumentSid;
        this.phoneNumber = phoneNumber;
        this.capabilities = capabilities;
        this.friendlyName = friendlyName;
        this.status = status;
        this.failureReason = failureReason;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.email = email;
        this.ccEmails = ccEmails;
        this.url = url;
        this.contactTitle = contactTitle;
        this.contactPhoneNumber = contactPhoneNumber;
        this.bulkHostingRequestSid = bulkHostingRequestSid;
        this.nextStep = nextStep;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIncomingPhoneNumberSid() {
        return this.incomingPhoneNumberSid;
    }

    public final String getAddressSid() {
        return this.addressSid;
    }

    public final String getSigningDocumentSid() {
        return this.signingDocumentSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getFailureReason() {
        return this.failureReason;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getEmail() {
        return this.email;
    }

    public final List<String> getCcEmails() {
        return this.ccEmails;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getContactTitle() {
        return this.contactTitle;
    }

    public final PhoneNumber getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public final String getBulkHostingRequestSid() {
        return this.bulkHostingRequestSid;
    }

    public final String getNextStep() {
        return this.nextStep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostedNumberOrder other = (HostedNumberOrder)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.incomingPhoneNumberSid, other.incomingPhoneNumberSid) && Objects.equals(this.addressSid, other.addressSid) && Objects.equals(this.signingDocumentSid, other.signingDocumentSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.email, other.email) && Objects.equals(this.ccEmails, other.ccEmails) && Objects.equals(this.url, other.url) && Objects.equals(this.contactTitle, other.contactTitle) && Objects.equals(this.contactPhoneNumber, other.contactPhoneNumber) && Objects.equals(this.bulkHostingRequestSid, other.bulkHostingRequestSid) && Objects.equals(this.nextStep, other.nextStep);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.incomingPhoneNumberSid, this.addressSid, this.signingDocumentSid, this.phoneNumber, this.capabilities, this.friendlyName, this.status, this.failureReason, this.dateCreated, this.dateUpdated, this.email, this.ccEmails, this.url, this.contactTitle, this.contactPhoneNumber, this.bulkHostingRequestSid, this.nextStep});
    }

    public String toString() {
        return "HostedNumberOrder(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", incomingPhoneNumberSid=" + this.getIncomingPhoneNumberSid() + ", addressSid=" + this.getAddressSid() + ", signingDocumentSid=" + this.getSigningDocumentSid() + ", phoneNumber=" + this.getPhoneNumber() + ", capabilities=" + this.getCapabilities() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", failureReason=" + this.getFailureReason() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", email=" + this.getEmail() + ", ccEmails=" + this.getCcEmails() + ", url=" + this.getUrl() + ", contactTitle=" + this.getContactTitle() + ", contactPhoneNumber=" + this.getContactPhoneNumber() + ", bulkHostingRequestSid=" + this.getBulkHostingRequestSid() + ", nextStep=" + this.getNextStep() + ")";
    }

    public static enum Status {
        RECEIVED("received"),
        VERIFIED("verified"),
        PENDING_LOA("pending-loa"),
        CARRIER_PROCESSING("carrier-processing"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTION_REQUIRED("action-required");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

