/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.BulkHostedNumberOrder;

public class BulkHostedNumberOrderFetcher
extends Fetcher<BulkHostedNumberOrder> {
    private String pathBulkHostingSid;
    private String orderStatus;

    public BulkHostedNumberOrderFetcher(String pathBulkHostingSid) {
        this.pathBulkHostingSid = pathBulkHostingSid;
    }

    public BulkHostedNumberOrderFetcher setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @Override
    public BulkHostedNumberOrder fetch(TwilioRestClient client) {
        String path = "/v2/HostedNumber/Orders/Bulk/{BulkHostingSid}";
        path = path.replace("{BulkHostingSid}", this.pathBulkHostingSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BulkHostedNumberOrder fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BulkHostedNumberOrder.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.orderStatus != null) {
            request.addQueryParam("OrderStatus", this.orderStatus);
        }
    }
}

