/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.PortingPortInFetchFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortingPortInFetch
extends Resource {
    private static final long serialVersionUID = 3228491846364L;
    private final String portInRequestSid;
    private final URI url;
    private final String accountSid;
    private final List<String> notificationEmails;
    private final LocalDate targetPortInDate;
    private final String targetPortInTimeRangeStart;
    private final String targetPortInTimeRangeEnd;
    private final String portInRequestStatus;
    private final Map<String, Object> losingCarrierInformation;
    private final List<Map<String, Object>> phoneNumbers;
    private final List<String> documents;

    public static PortingPortInFetchFetcher fetcher(String pathPortInRequestSid) {
        return new PortingPortInFetchFetcher(pathPortInRequestSid);
    }

    public static PortingPortInFetch fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortInFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PortingPortInFetch fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PortingPortInFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PortingPortInFetch(@JsonProperty(value="port_in_request_sid") String portInRequestSid, @JsonProperty(value="url") URI url, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="notification_emails") List<String> notificationEmails, @JsonProperty(value="target_port_in_date") String targetPortInDate, @JsonProperty(value="target_port_in_time_range_start") String targetPortInTimeRangeStart, @JsonProperty(value="target_port_in_time_range_end") String targetPortInTimeRangeEnd, @JsonProperty(value="port_in_request_status") String portInRequestStatus, @JsonProperty(value="losing_carrier_information") Map<String, Object> losingCarrierInformation, @JsonProperty(value="phone_numbers") List<Map<String, Object>> phoneNumbers, @JsonProperty(value="documents") List<String> documents) {
        this.portInRequestSid = portInRequestSid;
        this.url = url;
        this.accountSid = accountSid;
        this.notificationEmails = notificationEmails;
        this.targetPortInDate = DateConverter.localDateFromString(targetPortInDate);
        this.targetPortInTimeRangeStart = targetPortInTimeRangeStart;
        this.targetPortInTimeRangeEnd = targetPortInTimeRangeEnd;
        this.portInRequestStatus = portInRequestStatus;
        this.losingCarrierInformation = losingCarrierInformation;
        this.phoneNumbers = phoneNumbers;
        this.documents = documents;
    }

    public final String getPortInRequestSid() {
        return this.portInRequestSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final List<String> getNotificationEmails() {
        return this.notificationEmails;
    }

    public final LocalDate getTargetPortInDate() {
        return this.targetPortInDate;
    }

    public final String getTargetPortInTimeRangeStart() {
        return this.targetPortInTimeRangeStart;
    }

    public final String getTargetPortInTimeRangeEnd() {
        return this.targetPortInTimeRangeEnd;
    }

    public final String getPortInRequestStatus() {
        return this.portInRequestStatus;
    }

    public final Map<String, Object> getLosingCarrierInformation() {
        return this.losingCarrierInformation;
    }

    public final List<Map<String, Object>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public final List<String> getDocuments() {
        return this.documents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortingPortInFetch other = (PortingPortInFetch)o;
        return Objects.equals(this.portInRequestSid, other.portInRequestSid) && Objects.equals(this.url, other.url) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.notificationEmails, other.notificationEmails) && Objects.equals(this.targetPortInDate, other.targetPortInDate) && Objects.equals(this.targetPortInTimeRangeStart, other.targetPortInTimeRangeStart) && Objects.equals(this.targetPortInTimeRangeEnd, other.targetPortInTimeRangeEnd) && Objects.equals(this.portInRequestStatus, other.portInRequestStatus) && Objects.equals(this.losingCarrierInformation, other.losingCarrierInformation) && Objects.equals(this.phoneNumbers, other.phoneNumbers) && Objects.equals(this.documents, other.documents);
    }

    public int hashCode() {
        return Objects.hash(this.portInRequestSid, this.url, this.accountSid, this.notificationEmails, this.targetPortInDate, this.targetPortInTimeRangeStart, this.targetPortInTimeRangeEnd, this.portInRequestStatus, this.losingCarrierInformation, this.phoneNumbers, this.documents);
    }

    public String toString() {
        return "PortingPortInFetch(portInRequestSid=" + this.getPortInRequestSid() + ", url=" + this.getUrl() + ", accountSid=" + this.getAccountSid() + ", notificationEmails=" + this.getNotificationEmails() + ", targetPortInDate=" + this.getTargetPortInDate() + ", targetPortInTimeRangeStart=" + this.getTargetPortInTimeRangeStart() + ", targetPortInTimeRangeEnd=" + this.getTargetPortInTimeRangeEnd() + ", portInRequestStatus=" + this.getPortInRequestStatus() + ", losingCarrierInformation=" + this.getLosingCarrierInformation() + ", phoneNumbers=" + this.getPhoneNumbers() + ", documents=" + this.getDocuments() + ")";
    }
}

