/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v1.BulkEligibilityCreator;
import com.twilio.rest.numbers.v1.BulkEligibilityFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkEligibility
extends Resource {
    private static final long serialVersionUID = 38354491175250L;
    private final String requestId;
    private final URI url;
    private final List<Map<String, Object>> results;
    private final String friendlyName;
    private final String status;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateCompleted;

    public static BulkEligibilityCreator creator() {
        return new BulkEligibilityCreator();
    }

    public static BulkEligibilityFetcher fetcher(String pathRequestId) {
        return new BulkEligibilityFetcher(pathRequestId);
    }

    public static BulkEligibility fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BulkEligibility.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BulkEligibility fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BulkEligibility.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BulkEligibility(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="url") URI url, @JsonProperty(value="results") List<Map<String, Object>> results, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") String status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_completed") String dateCompleted) {
        this.requestId = requestId;
        this.url = url;
        this.results = results;
        this.friendlyName = friendlyName;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateCompleted = DateConverter.iso8601DateTimeFromString(dateCompleted);
    }

    public final String getRequestId() {
        return this.requestId;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getStatus() {
        return this.status;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkEligibility other = (BulkEligibility)o;
        return Objects.equals(this.requestId, other.requestId) && Objects.equals(this.url, other.url) && Objects.equals(this.results, other.results) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.status, other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateCompleted, other.dateCompleted);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.url, this.results, this.friendlyName, this.status, this.dateCreated, this.dateCompleted);
    }

    public String toString() {
        return "BulkEligibility(requestId=" + this.getRequestId() + ", url=" + this.getUrl() + ", results=" + this.getResults() + ", friendlyName=" + this.getFriendlyName() + ", status=" + this.getStatus() + ", dateCreated=" + this.getDateCreated() + ", dateCompleted=" + this.getDateCompleted() + ")";
    }
}

