/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.notify.v1.service.NotificationCreator;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
extends Resource {
    private static final long serialVersionUID = 129411229878484L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final ZonedDateTime dateCreated;
    private final List<String> identities;
    private final List<String> tags;
    private final List<String> segments;
    private final Priority priority;
    private final Integer ttl;
    private final String title;
    private final String body;
    private final String sound;
    private final String action;
    private final Map<String, Object> data;
    private final Map<String, Object> apn;
    private final Map<String, Object> gcm;
    private final Map<String, Object> fcm;
    private final Map<String, Object> sms;
    private final Map<String, Object> facebookMessenger;
    private final Map<String, Object> alexa;

    public static NotificationCreator creator(String pathServiceSid) {
        return new NotificationCreator(pathServiceSid);
    }

    public static Notification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Notification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Notification(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="identities") List<String> identities, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="segments") List<String> segments, @JsonProperty(value="priority") Priority priority, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="sound") String sound, @JsonProperty(value="action") String action, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="apn") Map<String, Object> apn, @JsonProperty(value="gcm") Map<String, Object> gcm, @JsonProperty(value="fcm") Map<String, Object> fcm, @JsonProperty(value="sms") Map<String, Object> sms, @JsonProperty(value="facebook_messenger") Map<String, Object> facebookMessenger, @JsonProperty(value="alexa") Map<String, Object> alexa) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.identities = identities;
        this.tags = tags;
        this.segments = segments;
        this.priority = priority;
        this.ttl = ttl;
        this.title = title;
        this.body = body;
        this.sound = sound;
        this.action = action;
        this.data = data;
        this.apn = apn;
        this.gcm = gcm;
        this.fcm = fcm;
        this.sms = sms;
        this.facebookMessenger = facebookMessenger;
        this.alexa = alexa;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final List<String> getIdentities() {
        return this.identities;
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final List<String> getSegments() {
        return this.segments;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getBody() {
        return this.body;
    }

    public final String getSound() {
        return this.sound;
    }

    public final String getAction() {
        return this.action;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public final Map<String, Object> getApn() {
        return this.apn;
    }

    public final Map<String, Object> getGcm() {
        return this.gcm;
    }

    public final Map<String, Object> getFcm() {
        return this.fcm;
    }

    public final Map<String, Object> getSms() {
        return this.sms;
    }

    public final Map<String, Object> getFacebookMessenger() {
        return this.facebookMessenger;
    }

    public final Map<String, Object> getAlexa() {
        return this.alexa;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification other = (Notification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.identities, other.identities) && Objects.equals(this.tags, other.tags) && Objects.equals(this.segments, other.segments) && Objects.equals((Object)this.priority, (Object)other.priority) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.sound, other.sound) && Objects.equals(this.action, other.action) && Objects.equals(this.data, other.data) && Objects.equals(this.apn, other.apn) && Objects.equals(this.gcm, other.gcm) && Objects.equals(this.fcm, other.fcm) && Objects.equals(this.sms, other.sms) && Objects.equals(this.facebookMessenger, other.facebookMessenger) && Objects.equals(this.alexa, other.alexa);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.identities, this.tags, this.segments, this.priority, this.ttl, this.title, this.body, this.sound, this.action, this.data, this.apn, this.gcm, this.fcm, this.sms, this.facebookMessenger, this.alexa});
    }

    public String toString() {
        return "Notification(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", dateCreated=" + this.getDateCreated() + ", identities=" + this.getIdentities() + ", tags=" + this.getTags() + ", segments=" + this.getSegments() + ", priority=" + (Object)((Object)this.getPriority()) + ", ttl=" + this.getTtl() + ", title=" + this.getTitle() + ", body=" + this.getBody() + ", sound=" + this.getSound() + ", action=" + this.getAction() + ", data=" + this.getData() + ", apn=" + this.getApn() + ", gcm=" + this.getGcm() + ", fcm=" + this.getFcm() + ", sms=" + this.getSms() + ", facebookMessenger=" + this.getFacebookMessenger() + ", alexa=" + this.getAlexa() + ")";
    }

    public static enum Priority {
        HIGH("high"),
        LOW("low");

        private final String value;

        private Priority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Priority forValue(String value) {
            return (Priority)Promoter.enumFromString((String)value, (Enum[])Priority.values());
        }
    }
}

