/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.app;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.microvisor.v1.app.AppManifestFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppManifest
extends Resource {
    private static final long serialVersionUID = 249809073531699L;
    private final String appSid;
    private final String hash;
    private final String encodedBytes;
    private final URI url;

    public static AppManifestFetcher fetcher(String pathAppSid) {
        return new AppManifestFetcher(pathAppSid);
    }

    public static AppManifest fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AppManifest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AppManifest fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AppManifest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AppManifest(@JsonProperty(value="app_sid") String appSid, @JsonProperty(value="hash") String hash, @JsonProperty(value="encoded_bytes") String encodedBytes, @JsonProperty(value="url") URI url) {
        this.appSid = appSid;
        this.hash = hash;
        this.encodedBytes = encodedBytes;
        this.url = url;
    }

    public final String getAppSid() {
        return this.appSid;
    }

    public final String getHash() {
        return this.hash;
    }

    public final String getEncodedBytes() {
        return this.encodedBytes;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppManifest other = (AppManifest)o;
        return Objects.equals(this.appSid, other.appSid) && Objects.equals(this.hash, other.hash) && Objects.equals(this.encodedBytes, other.encodedBytes) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.appSid, this.hash, this.encodedBytes, this.url);
    }

    public String toString() {
        return "AppManifest(appSid=" + this.getAppSid() + ", hash=" + this.getHash() + ", encodedBytes=" + this.getEncodedBytes() + ", url=" + this.getUrl() + ")";
    }
}

