/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.Device;

public class DeviceUpdater
extends Updater<Device> {
    private String pathSid;
    private String uniqueName;
    private String targetApp;
    private Boolean loggingEnabled;
    private Boolean restartApp;

    public DeviceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public DeviceUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public DeviceUpdater setTargetApp(String targetApp) {
        this.targetApp = targetApp;
        return this;
    }

    public DeviceUpdater setLoggingEnabled(Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public DeviceUpdater setRestartApp(Boolean restartApp) {
        this.restartApp = restartApp;
        return this;
    }

    @Override
    public Device update(TwilioRestClient client) {
        String path = "/v1/Devices/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MICROVISOR.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.targetApp != null) {
            request.addPostParam("TargetApp", this.targetApp);
        }
        if (this.loggingEnabled != null) {
            request.addPostParam("LoggingEnabled", this.loggingEnabled.toString());
        }
        if (this.restartApp != null) {
            request.addPostParam("RestartApp", this.restartApp.toString());
        }
    }
}

