/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.microvisor.v1.AccountSecretCreator;
import com.twilio.rest.microvisor.v1.AccountSecretDeleter;
import com.twilio.rest.microvisor.v1.AccountSecretFetcher;
import com.twilio.rest.microvisor.v1.AccountSecretReader;
import com.twilio.rest.microvisor.v1.AccountSecretUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountSecret
extends Resource {
    private static final long serialVersionUID = 245444757442788L;
    private final String key;
    private final ZonedDateTime dateRotated;
    private final URI url;

    public static AccountSecretCreator creator(String key, String value) {
        return new AccountSecretCreator(key, value);
    }

    public static AccountSecretDeleter deleter(String pathKey) {
        return new AccountSecretDeleter(pathKey);
    }

    public static AccountSecretFetcher fetcher(String pathKey) {
        return new AccountSecretFetcher(pathKey);
    }

    public static AccountSecretReader reader() {
        return new AccountSecretReader();
    }

    public static AccountSecretUpdater updater(String pathKey, String value) {
        return new AccountSecretUpdater(pathKey, value);
    }

    public static AccountSecret fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccountSecret.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AccountSecret fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccountSecret.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AccountSecret(@JsonProperty(value="key") String key, @JsonProperty(value="date_rotated") String dateRotated, @JsonProperty(value="url") URI url) {
        this.key = key;
        this.dateRotated = DateConverter.iso8601DateTimeFromString(dateRotated);
        this.url = url;
    }

    public final String getKey() {
        return this.key;
    }

    public final ZonedDateTime getDateRotated() {
        return this.dateRotated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSecret other = (AccountSecret)o;
        return Objects.equals(this.key, other.key) && Objects.equals(this.dateRotated, other.dateRotated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.dateRotated, this.url);
    }

    public String toString() {
        return "AccountSecret(key=" + this.getKey() + ", dateRotated=" + this.getDateRotated() + ", url=" + this.getUrl() + ")";
    }
}

