/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.TollfreeVerification;
import com.twilio.type.PhoneNumber;
import java.util.List;

public class TollfreeVerificationUpdater
extends Updater<TollfreeVerification> {
    private String pathSid;
    private String businessName;
    private String businessWebsite;
    private String notificationEmail;
    private List<String> useCaseCategories;
    private String useCaseSummary;
    private String productionMessageSample;
    private List<String> optInImageUrls;
    private TollfreeVerification.OptInType optInType;
    private String messageVolume;
    private String businessStreetAddress;
    private String businessStreetAddress2;
    private String businessCity;
    private String businessStateProvinceRegion;
    private String businessPostalCode;
    private String businessCountry;
    private String additionalInformation;
    private String businessContactFirstName;
    private String businessContactLastName;
    private String businessContactEmail;
    private PhoneNumber businessContactPhone;
    private String editReason;

    public TollfreeVerificationUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public TollfreeVerificationUpdater setBusinessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public TollfreeVerificationUpdater setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    public TollfreeVerificationUpdater setUseCaseCategories(List<String> useCaseCategories) {
        this.useCaseCategories = useCaseCategories;
        return this;
    }

    public TollfreeVerificationUpdater setUseCaseCategories(String useCaseCategories) {
        return this.setUseCaseCategories(Promoter.listOfOne(useCaseCategories));
    }

    public TollfreeVerificationUpdater setUseCaseSummary(String useCaseSummary) {
        this.useCaseSummary = useCaseSummary;
        return this;
    }

    public TollfreeVerificationUpdater setProductionMessageSample(String productionMessageSample) {
        this.productionMessageSample = productionMessageSample;
        return this;
    }

    public TollfreeVerificationUpdater setOptInImageUrls(List<String> optInImageUrls) {
        this.optInImageUrls = optInImageUrls;
        return this;
    }

    public TollfreeVerificationUpdater setOptInImageUrls(String optInImageUrls) {
        return this.setOptInImageUrls(Promoter.listOfOne(optInImageUrls));
    }

    public TollfreeVerificationUpdater setOptInType(TollfreeVerification.OptInType optInType) {
        this.optInType = optInType;
        return this;
    }

    public TollfreeVerificationUpdater setMessageVolume(String messageVolume) {
        this.messageVolume = messageVolume;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessStreetAddress(String businessStreetAddress) {
        this.businessStreetAddress = businessStreetAddress;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessStreetAddress2(String businessStreetAddress2) {
        this.businessStreetAddress2 = businessStreetAddress2;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessStateProvinceRegion(String businessStateProvinceRegion) {
        this.businessStateProvinceRegion = businessStateProvinceRegion;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessPostalCode(String businessPostalCode) {
        this.businessPostalCode = businessPostalCode;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
        return this;
    }

    public TollfreeVerificationUpdater setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessContactFirstName(String businessContactFirstName) {
        this.businessContactFirstName = businessContactFirstName;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessContactLastName(String businessContactLastName) {
        this.businessContactLastName = businessContactLastName;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessContactEmail(String businessContactEmail) {
        this.businessContactEmail = businessContactEmail;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessContactPhone(PhoneNumber businessContactPhone) {
        this.businessContactPhone = businessContactPhone;
        return this;
    }

    public TollfreeVerificationUpdater setBusinessContactPhone(String businessContactPhone) {
        return this.setBusinessContactPhone(Promoter.phoneNumberFromString(businessContactPhone));
    }

    public TollfreeVerificationUpdater setEditReason(String editReason) {
        this.editReason = editReason;
        return this;
    }

    @Override
    public TollfreeVerification update(TwilioRestClient client) {
        String path = "/v1/Tollfree/Verifications/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TollfreeVerification update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TollfreeVerification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.businessName != null) {
            request.addPostParam("BusinessName", this.businessName);
        }
        if (this.businessWebsite != null) {
            request.addPostParam("BusinessWebsite", this.businessWebsite);
        }
        if (this.notificationEmail != null) {
            request.addPostParam("NotificationEmail", this.notificationEmail);
        }
        if (this.useCaseCategories != null) {
            for (String prop : this.useCaseCategories) {
                request.addPostParam("UseCaseCategories", prop);
            }
        }
        if (this.useCaseSummary != null) {
            request.addPostParam("UseCaseSummary", this.useCaseSummary);
        }
        if (this.productionMessageSample != null) {
            request.addPostParam("ProductionMessageSample", this.productionMessageSample);
        }
        if (this.optInImageUrls != null) {
            for (String prop : this.optInImageUrls) {
                request.addPostParam("OptInImageUrls", prop);
            }
        }
        if (this.optInType != null) {
            request.addPostParam("OptInType", this.optInType.toString());
        }
        if (this.messageVolume != null) {
            request.addPostParam("MessageVolume", this.messageVolume);
        }
        if (this.businessStreetAddress != null) {
            request.addPostParam("BusinessStreetAddress", this.businessStreetAddress);
        }
        if (this.businessStreetAddress2 != null) {
            request.addPostParam("BusinessStreetAddress2", this.businessStreetAddress2);
        }
        if (this.businessCity != null) {
            request.addPostParam("BusinessCity", this.businessCity);
        }
        if (this.businessStateProvinceRegion != null) {
            request.addPostParam("BusinessStateProvinceRegion", this.businessStateProvinceRegion);
        }
        if (this.businessPostalCode != null) {
            request.addPostParam("BusinessPostalCode", this.businessPostalCode);
        }
        if (this.businessCountry != null) {
            request.addPostParam("BusinessCountry", this.businessCountry);
        }
        if (this.additionalInformation != null) {
            request.addPostParam("AdditionalInformation", this.additionalInformation);
        }
        if (this.businessContactFirstName != null) {
            request.addPostParam("BusinessContactFirstName", this.businessContactFirstName);
        }
        if (this.businessContactLastName != null) {
            request.addPostParam("BusinessContactLastName", this.businessContactLastName);
        }
        if (this.businessContactEmail != null) {
            request.addPostParam("BusinessContactEmail", this.businessContactEmail);
        }
        if (this.businessContactPhone != null) {
            request.addPostParam("BusinessContactPhone", this.businessContactPhone.toString());
        }
        if (this.editReason != null) {
            request.addPostParam("EditReason", this.editReason);
        }
    }
}

