/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.TollfreeVerification;
import com.twilio.type.PhoneNumber;
import java.util.List;

public class TollfreeVerificationCreator
extends Creator<TollfreeVerification> {
    private String businessName;
    private String businessWebsite;
    private String notificationEmail;
    private List<String> useCaseCategories;
    private String useCaseSummary;
    private String productionMessageSample;
    private List<String> optInImageUrls;
    private TollfreeVerification.OptInType optInType;
    private String messageVolume;
    private String tollfreePhoneNumberSid;
    private String customerProfileSid;
    private String businessStreetAddress;
    private String businessStreetAddress2;
    private String businessCity;
    private String businessStateProvinceRegion;
    private String businessPostalCode;
    private String businessCountry;
    private String additionalInformation;
    private String businessContactFirstName;
    private String businessContactLastName;
    private String businessContactEmail;
    private PhoneNumber businessContactPhone;
    private String externalReferenceId;

    public TollfreeVerificationCreator(String businessName, String businessWebsite, String notificationEmail, List<String> useCaseCategories, String useCaseSummary, String productionMessageSample, List<String> optInImageUrls, TollfreeVerification.OptInType optInType, String messageVolume, String tollfreePhoneNumberSid) {
        this.businessName = businessName;
        this.businessWebsite = businessWebsite;
        this.notificationEmail = notificationEmail;
        this.useCaseCategories = useCaseCategories;
        this.useCaseSummary = useCaseSummary;
        this.productionMessageSample = productionMessageSample;
        this.optInImageUrls = optInImageUrls;
        this.optInType = optInType;
        this.messageVolume = messageVolume;
        this.tollfreePhoneNumberSid = tollfreePhoneNumberSid;
    }

    public TollfreeVerificationCreator setBusinessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    public TollfreeVerificationCreator setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public TollfreeVerificationCreator setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    public TollfreeVerificationCreator setUseCaseCategories(List<String> useCaseCategories) {
        this.useCaseCategories = useCaseCategories;
        return this;
    }

    public TollfreeVerificationCreator setUseCaseCategories(String useCaseCategories) {
        return this.setUseCaseCategories(Promoter.listOfOne(useCaseCategories));
    }

    public TollfreeVerificationCreator setUseCaseSummary(String useCaseSummary) {
        this.useCaseSummary = useCaseSummary;
        return this;
    }

    public TollfreeVerificationCreator setProductionMessageSample(String productionMessageSample) {
        this.productionMessageSample = productionMessageSample;
        return this;
    }

    public TollfreeVerificationCreator setOptInImageUrls(List<String> optInImageUrls) {
        this.optInImageUrls = optInImageUrls;
        return this;
    }

    public TollfreeVerificationCreator setOptInImageUrls(String optInImageUrls) {
        return this.setOptInImageUrls(Promoter.listOfOne(optInImageUrls));
    }

    public TollfreeVerificationCreator setOptInType(TollfreeVerification.OptInType optInType) {
        this.optInType = optInType;
        return this;
    }

    public TollfreeVerificationCreator setMessageVolume(String messageVolume) {
        this.messageVolume = messageVolume;
        return this;
    }

    public TollfreeVerificationCreator setTollfreePhoneNumberSid(String tollfreePhoneNumberSid) {
        this.tollfreePhoneNumberSid = tollfreePhoneNumberSid;
        return this;
    }

    public TollfreeVerificationCreator setCustomerProfileSid(String customerProfileSid) {
        this.customerProfileSid = customerProfileSid;
        return this;
    }

    public TollfreeVerificationCreator setBusinessStreetAddress(String businessStreetAddress) {
        this.businessStreetAddress = businessStreetAddress;
        return this;
    }

    public TollfreeVerificationCreator setBusinessStreetAddress2(String businessStreetAddress2) {
        this.businessStreetAddress2 = businessStreetAddress2;
        return this;
    }

    public TollfreeVerificationCreator setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
        return this;
    }

    public TollfreeVerificationCreator setBusinessStateProvinceRegion(String businessStateProvinceRegion) {
        this.businessStateProvinceRegion = businessStateProvinceRegion;
        return this;
    }

    public TollfreeVerificationCreator setBusinessPostalCode(String businessPostalCode) {
        this.businessPostalCode = businessPostalCode;
        return this;
    }

    public TollfreeVerificationCreator setBusinessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
        return this;
    }

    public TollfreeVerificationCreator setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public TollfreeVerificationCreator setBusinessContactFirstName(String businessContactFirstName) {
        this.businessContactFirstName = businessContactFirstName;
        return this;
    }

    public TollfreeVerificationCreator setBusinessContactLastName(String businessContactLastName) {
        this.businessContactLastName = businessContactLastName;
        return this;
    }

    public TollfreeVerificationCreator setBusinessContactEmail(String businessContactEmail) {
        this.businessContactEmail = businessContactEmail;
        return this;
    }

    public TollfreeVerificationCreator setBusinessContactPhone(PhoneNumber businessContactPhone) {
        this.businessContactPhone = businessContactPhone;
        return this;
    }

    public TollfreeVerificationCreator setBusinessContactPhone(String businessContactPhone) {
        return this.setBusinessContactPhone(Promoter.phoneNumberFromString(businessContactPhone));
    }

    public TollfreeVerificationCreator setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @Override
    public TollfreeVerification create(TwilioRestClient client) {
        String path = "/v1/Tollfree/Verifications";
        path = path.replace("{BusinessName}", this.businessName.toString());
        path = path.replace("{BusinessWebsite}", this.businessWebsite.toString());
        path = path.replace("{NotificationEmail}", this.notificationEmail.toString());
        path = path.replace("{UseCaseCategories}", this.useCaseCategories.toString());
        path = path.replace("{UseCaseSummary}", this.useCaseSummary.toString());
        path = path.replace("{ProductionMessageSample}", this.productionMessageSample.toString());
        path = path.replace("{OptInImageUrls}", this.optInImageUrls.toString());
        path = path.replace("{OptInType}", this.optInType.toString());
        path = path.replace("{MessageVolume}", this.messageVolume.toString());
        path = path.replace("{TollfreePhoneNumberSid}", this.tollfreePhoneNumberSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TollfreeVerification creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TollfreeVerification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.businessName != null) {
            request.addPostParam("BusinessName", this.businessName);
        }
        if (this.businessWebsite != null) {
            request.addPostParam("BusinessWebsite", this.businessWebsite);
        }
        if (this.notificationEmail != null) {
            request.addPostParam("NotificationEmail", this.notificationEmail);
        }
        if (this.useCaseCategories != null) {
            for (String prop : this.useCaseCategories) {
                request.addPostParam("UseCaseCategories", prop);
            }
        }
        if (this.useCaseSummary != null) {
            request.addPostParam("UseCaseSummary", this.useCaseSummary);
        }
        if (this.productionMessageSample != null) {
            request.addPostParam("ProductionMessageSample", this.productionMessageSample);
        }
        if (this.optInImageUrls != null) {
            for (String prop : this.optInImageUrls) {
                request.addPostParam("OptInImageUrls", prop);
            }
        }
        if (this.optInType != null) {
            request.addPostParam("OptInType", this.optInType.toString());
        }
        if (this.messageVolume != null) {
            request.addPostParam("MessageVolume", this.messageVolume);
        }
        if (this.tollfreePhoneNumberSid != null) {
            request.addPostParam("TollfreePhoneNumberSid", this.tollfreePhoneNumberSid);
        }
        if (this.customerProfileSid != null) {
            request.addPostParam("CustomerProfileSid", this.customerProfileSid);
        }
        if (this.businessStreetAddress != null) {
            request.addPostParam("BusinessStreetAddress", this.businessStreetAddress);
        }
        if (this.businessStreetAddress2 != null) {
            request.addPostParam("BusinessStreetAddress2", this.businessStreetAddress2);
        }
        if (this.businessCity != null) {
            request.addPostParam("BusinessCity", this.businessCity);
        }
        if (this.businessStateProvinceRegion != null) {
            request.addPostParam("BusinessStateProvinceRegion", this.businessStateProvinceRegion);
        }
        if (this.businessPostalCode != null) {
            request.addPostParam("BusinessPostalCode", this.businessPostalCode);
        }
        if (this.businessCountry != null) {
            request.addPostParam("BusinessCountry", this.businessCountry);
        }
        if (this.additionalInformation != null) {
            request.addPostParam("AdditionalInformation", this.additionalInformation);
        }
        if (this.businessContactFirstName != null) {
            request.addPostParam("BusinessContactFirstName", this.businessContactFirstName);
        }
        if (this.businessContactLastName != null) {
            request.addPostParam("BusinessContactLastName", this.businessContactLastName);
        }
        if (this.businessContactEmail != null) {
            request.addPostParam("BusinessContactEmail", this.businessContactEmail);
        }
        if (this.businessContactPhone != null) {
            request.addPostParam("BusinessContactPhone", this.businessContactPhone.toString());
        }
        if (this.externalReferenceId != null) {
            request.addPostParam("ExternalReferenceId", this.externalReferenceId);
        }
    }
}

