/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.LinkshorteningMessagingServiceDomainAssociation;

public class LinkshorteningMessagingServiceDomainAssociationFetcher
extends Fetcher<LinkshorteningMessagingServiceDomainAssociation> {
    private String pathMessagingServiceSid;

    public LinkshorteningMessagingServiceDomainAssociationFetcher(String pathMessagingServiceSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
    }

    @Override
    public LinkshorteningMessagingServiceDomainAssociation fetch(TwilioRestClient client) {
        String path = "/v1/LinkShortening/MessagingServices/{MessagingServiceSid}/Domain";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("LinkshorteningMessagingServiceDomainAssociation fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return LinkshorteningMessagingServiceDomainAssociation.fromJson(response.getStream(), client.getObjectMapper());
    }
}

