/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.DomainConfigMessagingServiceFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DomainConfigMessagingService
extends Resource {
    private static final long serialVersionUID = 37164874125386L;
    private final String domainSid;
    private final String configSid;
    private final String messagingServiceSid;
    private final URI fallbackUrl;
    private final URI callbackUrl;
    private final Boolean continueOnFailure;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static DomainConfigMessagingServiceFetcher fetcher(String pathMessagingServiceSid) {
        return new DomainConfigMessagingServiceFetcher(pathMessagingServiceSid);
    }

    public static DomainConfigMessagingService fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DomainConfigMessagingService.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DomainConfigMessagingService fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DomainConfigMessagingService.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DomainConfigMessagingService(@JsonProperty(value="domain_sid") String domainSid, @JsonProperty(value="config_sid") String configSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="fallback_url") URI fallbackUrl, @JsonProperty(value="callback_url") URI callbackUrl, @JsonProperty(value="continue_on_failure") Boolean continueOnFailure, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.domainSid = domainSid;
        this.configSid = configSid;
        this.messagingServiceSid = messagingServiceSid;
        this.fallbackUrl = fallbackUrl;
        this.callbackUrl = callbackUrl;
        this.continueOnFailure = continueOnFailure;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getDomainSid() {
        return this.domainSid;
    }

    public final String getConfigSid() {
        return this.configSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final URI getFallbackUrl() {
        return this.fallbackUrl;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final Boolean getContinueOnFailure() {
        return this.continueOnFailure;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainConfigMessagingService other = (DomainConfigMessagingService)o;
        return Objects.equals(this.domainSid, other.domainSid) && Objects.equals(this.configSid, other.configSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.fallbackUrl, other.fallbackUrl) && Objects.equals(this.callbackUrl, other.callbackUrl) && Objects.equals(this.continueOnFailure, other.continueOnFailure) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.domainSid, this.configSid, this.messagingServiceSid, this.fallbackUrl, this.callbackUrl, this.continueOnFailure, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "DomainConfigMessagingService(domainSid=" + this.getDomainSid() + ", configSid=" + this.getConfigSid() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", fallbackUrl=" + this.getFallbackUrl() + ", callbackUrl=" + this.getCallbackUrl() + ", continueOnFailure=" + this.getContinueOnFailure() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

