/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.lookups.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.lookups.v2.PhoneNumberFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneNumber
extends Resource {
    private static final long serialVersionUID = 85967722263894L;
    private final String callingCountryCode;
    private final String countryCode;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String nationalFormat;
    private final Boolean valid;
    private final List<ValidationError> validationErrors;
    private final Map<String, Object> callerName;
    private final Map<String, Object> simSwap;
    private final Map<String, Object> callForwarding;
    private final Map<String, Object> lineStatus;
    private final Map<String, Object> lineTypeIntelligence;
    private final Map<String, Object> identityMatch;
    private final Map<String, Object> reassignedNumber;
    private final Map<String, Object> smsPumpingRisk;
    private final Map<String, Object> phoneNumberQualityScore;
    private final URI url;

    public static PhoneNumberFetcher fetcher(String pathPhoneNumber) {
        return new PhoneNumberFetcher(pathPhoneNumber);
    }

    public static PhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="calling_country_code") String callingCountryCode, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="phone_number") com.twilio.type.PhoneNumber phoneNumber, @JsonProperty(value="national_format") String nationalFormat, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="validation_errors") List<ValidationError> validationErrors, @JsonProperty(value="caller_name") Map<String, Object> callerName, @JsonProperty(value="sim_swap") Map<String, Object> simSwap, @JsonProperty(value="call_forwarding") Map<String, Object> callForwarding, @JsonProperty(value="line_status") Map<String, Object> lineStatus, @JsonProperty(value="line_type_intelligence") Map<String, Object> lineTypeIntelligence, @JsonProperty(value="identity_match") Map<String, Object> identityMatch, @JsonProperty(value="reassigned_number") Map<String, Object> reassignedNumber, @JsonProperty(value="sms_pumping_risk") Map<String, Object> smsPumpingRisk, @JsonProperty(value="phone_number_quality_score") Map<String, Object> phoneNumberQualityScore, @JsonProperty(value="url") URI url) {
        this.callingCountryCode = callingCountryCode;
        this.countryCode = countryCode;
        this.phoneNumber = phoneNumber;
        this.nationalFormat = nationalFormat;
        this.valid = valid;
        this.validationErrors = validationErrors;
        this.callerName = callerName;
        this.simSwap = simSwap;
        this.callForwarding = callForwarding;
        this.lineStatus = lineStatus;
        this.lineTypeIntelligence = lineTypeIntelligence;
        this.identityMatch = identityMatch;
        this.reassignedNumber = reassignedNumber;
        this.smsPumpingRisk = smsPumpingRisk;
        this.phoneNumberQualityScore = phoneNumberQualityScore;
        this.url = url;
    }

    public final String getCallingCountryCode() {
        return this.callingCountryCode;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getNationalFormat() {
        return this.nationalFormat;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public final Map<String, Object> getCallerName() {
        return this.callerName;
    }

    public final Map<String, Object> getSimSwap() {
        return this.simSwap;
    }

    public final Map<String, Object> getCallForwarding() {
        return this.callForwarding;
    }

    public final Map<String, Object> getLineStatus() {
        return this.lineStatus;
    }

    public final Map<String, Object> getLineTypeIntelligence() {
        return this.lineTypeIntelligence;
    }

    public final Map<String, Object> getIdentityMatch() {
        return this.identityMatch;
    }

    public final Map<String, Object> getReassignedNumber() {
        return this.reassignedNumber;
    }

    public final Map<String, Object> getSmsPumpingRisk() {
        return this.smsPumpingRisk;
    }

    public final Map<String, Object> getPhoneNumberQualityScore() {
        return this.phoneNumberQualityScore;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.equals(this.callingCountryCode, other.callingCountryCode) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.nationalFormat, other.nationalFormat) && Objects.equals(this.valid, other.valid) && Objects.equals(this.validationErrors, other.validationErrors) && Objects.equals(this.callerName, other.callerName) && Objects.equals(this.simSwap, other.simSwap) && Objects.equals(this.callForwarding, other.callForwarding) && Objects.equals(this.lineStatus, other.lineStatus) && Objects.equals(this.lineTypeIntelligence, other.lineTypeIntelligence) && Objects.equals(this.identityMatch, other.identityMatch) && Objects.equals(this.reassignedNumber, other.reassignedNumber) && Objects.equals(this.smsPumpingRisk, other.smsPumpingRisk) && Objects.equals(this.phoneNumberQualityScore, other.phoneNumberQualityScore) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.callingCountryCode, this.countryCode, this.phoneNumber, this.nationalFormat, this.valid, this.validationErrors, this.callerName, this.simSwap, this.callForwarding, this.lineStatus, this.lineTypeIntelligence, this.identityMatch, this.reassignedNumber, this.smsPumpingRisk, this.phoneNumberQualityScore, this.url);
    }

    public String toString() {
        return "PhoneNumber(callingCountryCode=" + this.getCallingCountryCode() + ", countryCode=" + this.getCountryCode() + ", phoneNumber=" + this.getPhoneNumber() + ", nationalFormat=" + this.getNationalFormat() + ", valid=" + this.getValid() + ", validationErrors=" + this.getValidationErrors() + ", callerName=" + this.getCallerName() + ", simSwap=" + this.getSimSwap() + ", callForwarding=" + this.getCallForwarding() + ", lineStatus=" + this.getLineStatus() + ", lineTypeIntelligence=" + this.getLineTypeIntelligence() + ", identityMatch=" + this.getIdentityMatch() + ", reassignedNumber=" + this.getReassignedNumber() + ", smsPumpingRisk=" + this.getSmsPumpingRisk() + ", phoneNumberQualityScore=" + this.getPhoneNumberQualityScore() + ", url=" + this.getUrl() + ")";
    }

    public static enum ValidationError {
        TOO_SHORT("TOO_SHORT"),
        TOO_LONG("TOO_LONG"),
        INVALID_BUT_POSSIBLE("INVALID_BUT_POSSIBLE"),
        INVALID_COUNTRY_CODE("INVALID_COUNTRY_CODE"),
        INVALID_LENGTH("INVALID_LENGTH"),
        NOT_A_NUMBER("NOT_A_NUMBER");

        private final String value;

        private ValidationError(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ValidationError forValue(String value) {
            return (ValidationError)Promoter.enumFromString((String)value, (Enum[])ValidationError.values());
        }
    }
}

