/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.user;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.user.UserChannel;

public class UserChannelReader
extends Reader<UserChannel> {
    private String pathServiceSid;
    private String pathUserSid;
    private Integer pageSize;

    public UserChannelReader(String pathServiceSid, String pathUserSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathUserSid = pathUserSid;
    }

    public UserChannelReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<UserChannel> read(TwilioRestClient client) {
        return new ResourceSet<UserChannel>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UserChannel> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users/{UserSid}/Channels";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.IPMESSAGING.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<UserChannel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserChannel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("channels", response.getContent(), UserChannel.class, client.getObjectMapper());
    }

    @Override
    public Page<UserChannel> previousPage(Page<UserChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.IPMESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserChannel> nextPage(Page<UserChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.IPMESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserChannel> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

