/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.transcript.Sentence;

public class SentenceReader
extends Reader<Sentence> {
    private String pathTranscriptSid;
    private Boolean redacted;
    private Integer pageSize;

    public SentenceReader(String pathTranscriptSid) {
        this.pathTranscriptSid = pathTranscriptSid;
    }

    public SentenceReader setRedacted(Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    public SentenceReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Sentence> read(TwilioRestClient client) {
        return new ResourceSet<Sentence>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Sentence> firstPage(TwilioRestClient client) {
        String path = "/v2/Transcripts/{TranscriptSid}/Sentences";
        path = path.replace("{TranscriptSid}", this.pathTranscriptSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INTELLIGENCE.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Sentence> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sentence read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("sentences", response.getContent(), Sentence.class, client.getObjectMapper());
    }

    @Override
    public Page<Sentence> previousPage(Page<Sentence> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sentence> nextPage(Page<Sentence> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INTELLIGENCE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sentence> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.redacted != null) {
            request.addQueryParam("Redacted", this.redacted.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

