/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.transcript.MediaFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Media
extends Resource {
    private static final long serialVersionUID = 207829674287272L;
    private final String accountSid;
    private final URI mediaUrl;
    private final String serviceSid;
    private final String sid;
    private final URI url;

    public static MediaFetcher fetcher(String pathSid) {
        return new MediaFetcher(pathSid);
    }

    public static Media fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Media.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Media fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Media.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Media(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="media_url") URI mediaUrl, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.mediaUrl = mediaUrl;
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final URI getMediaUrl() {
        return this.mediaUrl;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Media other = (Media)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.mediaUrl, other.mediaUrl) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.mediaUrl, this.serviceSid, this.sid, this.url);
    }

    public String toString() {
        return "Media(accountSid=" + this.getAccountSid() + ", mediaUrl=" + this.getMediaUrl() + ", serviceSid=" + this.getServiceSid() + ", sid=" + this.getSid() + ", url=" + this.getUrl() + ")";
    }
}

