/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.Transcript;
import java.time.ZonedDateTime;
import java.util.Map;

public class TranscriptCreator
extends Creator<Transcript> {
    private String serviceSid;
    private Map<String, Object> channel;
    private String customerKey;
    private ZonedDateTime mediaStartTime;

    public TranscriptCreator(String serviceSid, Map<String, Object> channel) {
        this.serviceSid = serviceSid;
        this.channel = channel;
    }

    public TranscriptCreator setServiceSid(String serviceSid) {
        this.serviceSid = serviceSid;
        return this;
    }

    public TranscriptCreator setChannel(Map<String, Object> channel) {
        this.channel = channel;
        return this;
    }

    public TranscriptCreator setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
        return this;
    }

    public TranscriptCreator setMediaStartTime(ZonedDateTime mediaStartTime) {
        this.mediaStartTime = mediaStartTime;
        return this;
    }

    @Override
    public Transcript create(TwilioRestClient client) {
        String path = "/v2/Transcripts";
        path = path.replace("{ServiceSid}", this.serviceSid.toString());
        path = path.replace("{Channel}", this.channel.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Transcript creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Transcript.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.serviceSid != null) {
            request.addPostParam("ServiceSid", this.serviceSid);
        }
        if (this.channel != null) {
            request.addPostParam("Channel", Converter.mapToJson(this.channel));
        }
        if (this.customerKey != null) {
            request.addPostParam("CustomerKey", this.customerKey);
        }
        if (this.mediaStartTime != null) {
            request.addPostParam("MediaStartTime", this.mediaStartTime.toInstant().toString());
        }
    }
}

