/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.room;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.room.ParticipantFetcher;
import com.twilio.rest.insights.v1.room.ParticipantReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 21473393957377L;
    private final String participantSid;
    private final String participantIdentity;
    private final ZonedDateTime joinTime;
    private final ZonedDateTime leaveTime;
    private final Long durationSec;
    private final String accountSid;
    private final String roomSid;
    private final RoomStatus status;
    private final List<Codec> codecs;
    private final String endReason;
    private final Integer errorCode;
    private final String errorCodeUrl;
    private final TwilioRealm mediaRegion;
    private final Map<String, Object> properties;
    private final EdgeLocation edgeLocation;
    private final Map<String, Object> publisherInfo;
    private final URI url;

    public static ParticipantFetcher fetcher(String pathRoomSid, String pathParticipantSid) {
        return new ParticipantFetcher(pathRoomSid, pathParticipantSid);
    }

    public static ParticipantReader reader(String pathRoomSid) {
        return new ParticipantReader(pathRoomSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="participant_identity") String participantIdentity, @JsonProperty(value="join_time") String joinTime, @JsonProperty(value="leave_time") String leaveTime, @JsonProperty(value="duration_sec") Long durationSec, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="status") RoomStatus status, @JsonProperty(value="codecs") List<Codec> codecs, @JsonProperty(value="end_reason") String endReason, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="error_code_url") String errorCodeUrl, @JsonProperty(value="media_region") TwilioRealm mediaRegion, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="edge_location") EdgeLocation edgeLocation, @JsonProperty(value="publisher_info") Map<String, Object> publisherInfo, @JsonProperty(value="url") URI url) {
        this.participantSid = participantSid;
        this.participantIdentity = participantIdentity;
        this.joinTime = DateConverter.iso8601DateTimeFromString(joinTime);
        this.leaveTime = DateConverter.iso8601DateTimeFromString(leaveTime);
        this.durationSec = durationSec;
        this.accountSid = accountSid;
        this.roomSid = roomSid;
        this.status = status;
        this.codecs = codecs;
        this.endReason = endReason;
        this.errorCode = errorCode;
        this.errorCodeUrl = errorCodeUrl;
        this.mediaRegion = mediaRegion;
        this.properties = properties;
        this.edgeLocation = edgeLocation;
        this.publisherInfo = publisherInfo;
        this.url = url;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getParticipantIdentity() {
        return this.participantIdentity;
    }

    public final ZonedDateTime getJoinTime() {
        return this.joinTime;
    }

    public final ZonedDateTime getLeaveTime() {
        return this.leaveTime;
    }

    public final Long getDurationSec() {
        return this.durationSec;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final RoomStatus getStatus() {
        return this.status;
    }

    public final List<Codec> getCodecs() {
        return this.codecs;
    }

    public final String getEndReason() {
        return this.endReason;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorCodeUrl() {
        return this.errorCodeUrl;
    }

    public final TwilioRealm getMediaRegion() {
        return this.mediaRegion;
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final EdgeLocation getEdgeLocation() {
        return this.edgeLocation;
    }

    public final Map<String, Object> getPublisherInfo() {
        return this.publisherInfo;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.participantIdentity, other.participantIdentity) && Objects.equals(this.joinTime, other.joinTime) && Objects.equals(this.leaveTime, other.leaveTime) && Objects.equals(this.durationSec, other.durationSec) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.codecs, other.codecs) && Objects.equals(this.endReason, other.endReason) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorCodeUrl, other.errorCodeUrl) && Objects.equals((Object)this.mediaRegion, (Object)other.mediaRegion) && Objects.equals(this.properties, other.properties) && Objects.equals((Object)this.edgeLocation, (Object)other.edgeLocation) && Objects.equals(this.publisherInfo, other.publisherInfo) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.participantSid, this.participantIdentity, this.joinTime, this.leaveTime, this.durationSec, this.accountSid, this.roomSid, this.status, this.codecs, this.endReason, this.errorCode, this.errorCodeUrl, this.mediaRegion, this.properties, this.edgeLocation, this.publisherInfo, this.url});
    }

    public String toString() {
        return "Participant(participantSid=" + this.getParticipantSid() + ", participantIdentity=" + this.getParticipantIdentity() + ", joinTime=" + this.getJoinTime() + ", leaveTime=" + this.getLeaveTime() + ", durationSec=" + this.getDurationSec() + ", accountSid=" + this.getAccountSid() + ", roomSid=" + this.getRoomSid() + ", status=" + (Object)((Object)this.getStatus()) + ", codecs=" + this.getCodecs() + ", endReason=" + this.getEndReason() + ", errorCode=" + this.getErrorCode() + ", errorCodeUrl=" + this.getErrorCodeUrl() + ", mediaRegion=" + (Object)((Object)this.getMediaRegion()) + ", properties=" + this.getProperties() + ", edgeLocation=" + (Object)((Object)this.getEdgeLocation()) + ", publisherInfo=" + this.getPublisherInfo() + ", url=" + this.getUrl() + ")";
    }

    public static enum EdgeLocation {
        ASHBURN("ashburn"),
        DUBLIN("dublin"),
        FRANKFURT("frankfurt"),
        SINGAPORE("singapore"),
        SYDNEY("sydney"),
        SAO_PAULO("sao_paulo"),
        ROAMING("roaming"),
        UMATILLA("umatilla"),
        TOKYO("tokyo");

        private final String value;

        private EdgeLocation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EdgeLocation forValue(String value) {
            return (EdgeLocation)Promoter.enumFromString((String)value, (Enum[])EdgeLocation.values());
        }
    }

    public static enum Codec {
        VP8("VP8"),
        H264("H264"),
        VP9("VP9");

        private final String value;

        private Codec(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Codec forValue(String value) {
            return (Codec)Promoter.enumFromString((String)value, (Enum[])Codec.values());
        }
    }

    public static enum TwilioRealm {
        US1("us1"),
        US2("us2"),
        AU1("au1"),
        BR1("br1"),
        IE1("ie1"),
        JP1("jp1"),
        SG1("sg1"),
        IN1("in1"),
        DE1("de1"),
        GLL("gll");

        private final String value;

        private TwilioRealm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TwilioRealm forValue(String value) {
            return (TwilioRealm)Promoter.enumFromString((String)value, (Enum[])TwilioRealm.values());
        }
    }

    public static enum RoomStatus {
        IN_PROGRESS("in_progress"),
        COMPLETED("completed");

        private final String value;

        private RoomStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoomStatus forValue(String value) {
            return (RoomStatus)Promoter.enumFromString((String)value, (Enum[])RoomStatus.values());
        }
    }
}

