/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.call.Annotation;

public class AnnotationUpdater
extends Updater<Annotation> {
    private String pathCallSid;
    private Annotation.AnsweredBy answeredBy;
    private Annotation.ConnectivityIssue connectivityIssue;
    private String qualityIssues;
    private Boolean spam;
    private Integer callScore;
    private String comment;
    private String incident;

    public AnnotationUpdater(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public AnnotationUpdater setAnsweredBy(Annotation.AnsweredBy answeredBy) {
        this.answeredBy = answeredBy;
        return this;
    }

    public AnnotationUpdater setConnectivityIssue(Annotation.ConnectivityIssue connectivityIssue) {
        this.connectivityIssue = connectivityIssue;
        return this;
    }

    public AnnotationUpdater setQualityIssues(String qualityIssues) {
        this.qualityIssues = qualityIssues;
        return this;
    }

    public AnnotationUpdater setSpam(Boolean spam) {
        this.spam = spam;
        return this;
    }

    public AnnotationUpdater setCallScore(Integer callScore) {
        this.callScore = callScore;
        return this;
    }

    public AnnotationUpdater setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public AnnotationUpdater setIncident(String incident) {
        this.incident = incident;
        return this;
    }

    @Override
    public Annotation update(TwilioRestClient client) {
        String path = "/v1/Voice/{CallSid}/Annotation";
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.INSIGHTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Annotation update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Annotation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.answeredBy != null) {
            request.addPostParam("AnsweredBy", this.answeredBy.toString());
        }
        if (this.connectivityIssue != null) {
            request.addPostParam("ConnectivityIssue", this.connectivityIssue.toString());
        }
        if (this.qualityIssues != null) {
            request.addPostParam("QualityIssues", this.qualityIssues);
        }
        if (this.spam != null) {
            request.addPostParam("Spam", this.spam.toString());
        }
        if (this.callScore != null) {
            request.addPostParam("CallScore", this.callScore.toString());
        }
        if (this.comment != null) {
            request.addPostParam("Comment", this.comment);
        }
        if (this.incident != null) {
            request.addPostParam("Incident", this.incident);
        }
    }
}

