/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.Setting;

public class SettingUpdater
extends Updater<Setting> {
    private Boolean advancedFeatures;
    private Boolean voiceTrace;
    private String subaccountSid;

    public SettingUpdater setAdvancedFeatures(Boolean advancedFeatures) {
        this.advancedFeatures = advancedFeatures;
        return this;
    }

    public SettingUpdater setVoiceTrace(Boolean voiceTrace) {
        this.voiceTrace = voiceTrace;
        return this;
    }

    public SettingUpdater setSubaccountSid(String subaccountSid) {
        this.subaccountSid = subaccountSid;
        return this;
    }

    @Override
    public Setting update(TwilioRestClient client) {
        String path = "/v1/Voice/Settings";
        Request request = new Request(HttpMethod.POST, Domains.INSIGHTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Setting update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Setting.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.advancedFeatures != null) {
            request.addPostParam("AdvancedFeatures", this.advancedFeatures.toString());
        }
        if (this.voiceTrace != null) {
            request.addPostParam("VoiceTrace", this.voiceTrace.toString());
        }
        if (this.subaccountSid != null) {
            request.addPostParam("SubaccountSid", this.subaccountSid);
        }
    }
}

