/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.Setting;

public class SettingFetcher
extends Fetcher<Setting> {
    private String subaccountSid;

    public SettingFetcher setSubaccountSid(String subaccountSid) {
        this.subaccountSid = subaccountSid;
        return this;
    }

    @Override
    public Setting fetch(TwilioRestClient client) {
        String path = "/v1/Voice/Settings";
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Setting fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Setting.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.subaccountSid != null) {
            request.addQueryParam("SubaccountSid", this.subaccountSid);
        }
    }
}

