/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.insights.v1.RoomFetcher;
import com.twilio.rest.insights.v1.RoomReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Room
extends Resource {
    private static final long serialVersionUID = 140614978057184L;
    private final String accountSid;
    private final String roomSid;
    private final String roomName;
    private final ZonedDateTime createTime;
    private final ZonedDateTime endTime;
    private final RoomType roomType;
    private final RoomStatus roomStatus;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final CreatedMethod createdMethod;
    private final EndReason endReason;
    private final Integer maxParticipants;
    private final Integer uniqueParticipants;
    private final Integer uniqueParticipantIdentities;
    private final Integer concurrentParticipants;
    private final Integer maxConcurrentParticipants;
    private final List<Codec> codecs;
    private final TwilioRealm mediaRegion;
    private final Long durationSec;
    private final Long totalParticipantDurationSec;
    private final Long totalRecordingDurationSec;
    private final ProcessingState processingState;
    private final Boolean recordingEnabled;
    private final EdgeLocation edgeLocation;
    private final URI url;
    private final Map<String, String> links;

    public static RoomFetcher fetcher(String pathRoomSid) {
        return new RoomFetcher(pathRoomSid);
    }

    public static RoomReader reader() {
        return new RoomReader();
    }

    public static Room fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Room.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Room fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Room.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Room(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="room_name") String roomName, @JsonProperty(value="create_time") String createTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="room_type") RoomType roomType, @JsonProperty(value="room_status") RoomStatus roomStatus, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="created_method") CreatedMethod createdMethod, @JsonProperty(value="end_reason") EndReason endReason, @JsonProperty(value="max_participants") Integer maxParticipants, @JsonProperty(value="unique_participants") Integer uniqueParticipants, @JsonProperty(value="unique_participant_identities") Integer uniqueParticipantIdentities, @JsonProperty(value="concurrent_participants") Integer concurrentParticipants, @JsonProperty(value="max_concurrent_participants") Integer maxConcurrentParticipants, @JsonProperty(value="codecs") List<Codec> codecs, @JsonProperty(value="media_region") TwilioRealm mediaRegion, @JsonProperty(value="duration_sec") Long durationSec, @JsonProperty(value="total_participant_duration_sec") Long totalParticipantDurationSec, @JsonProperty(value="total_recording_duration_sec") Long totalRecordingDurationSec, @JsonProperty(value="processing_state") ProcessingState processingState, @JsonProperty(value="recording_enabled") Boolean recordingEnabled, @JsonProperty(value="edge_location") EdgeLocation edgeLocation, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.roomSid = roomSid;
        this.roomName = roomName;
        this.createTime = DateConverter.iso8601DateTimeFromString(createTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.roomType = roomType;
        this.roomStatus = roomStatus;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.createdMethod = createdMethod;
        this.endReason = endReason;
        this.maxParticipants = maxParticipants;
        this.uniqueParticipants = uniqueParticipants;
        this.uniqueParticipantIdentities = uniqueParticipantIdentities;
        this.concurrentParticipants = concurrentParticipants;
        this.maxConcurrentParticipants = maxConcurrentParticipants;
        this.codecs = codecs;
        this.mediaRegion = mediaRegion;
        this.durationSec = durationSec;
        this.totalParticipantDurationSec = totalParticipantDurationSec;
        this.totalRecordingDurationSec = totalRecordingDurationSec;
        this.processingState = processingState;
        this.recordingEnabled = recordingEnabled;
        this.edgeLocation = edgeLocation;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final String getRoomName() {
        return this.roomName;
    }

    public final ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public final RoomType getRoomType() {
        return this.roomType;
    }

    public final RoomStatus getRoomStatus() {
        return this.roomStatus;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final CreatedMethod getCreatedMethod() {
        return this.createdMethod;
    }

    public final EndReason getEndReason() {
        return this.endReason;
    }

    public final Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public final Integer getUniqueParticipants() {
        return this.uniqueParticipants;
    }

    public final Integer getUniqueParticipantIdentities() {
        return this.uniqueParticipantIdentities;
    }

    public final Integer getConcurrentParticipants() {
        return this.concurrentParticipants;
    }

    public final Integer getMaxConcurrentParticipants() {
        return this.maxConcurrentParticipants;
    }

    public final List<Codec> getCodecs() {
        return this.codecs;
    }

    public final TwilioRealm getMediaRegion() {
        return this.mediaRegion;
    }

    public final Long getDurationSec() {
        return this.durationSec;
    }

    public final Long getTotalParticipantDurationSec() {
        return this.totalParticipantDurationSec;
    }

    public final Long getTotalRecordingDurationSec() {
        return this.totalRecordingDurationSec;
    }

    public final ProcessingState getProcessingState() {
        return this.processingState;
    }

    public final Boolean getRecordingEnabled() {
        return this.recordingEnabled;
    }

    public final EdgeLocation getEdgeLocation() {
        return this.edgeLocation;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room other = (Room)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.roomName, other.roomName) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals((Object)this.roomType, (Object)other.roomType) && Objects.equals((Object)this.roomStatus, (Object)other.roomStatus) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals((Object)this.createdMethod, (Object)other.createdMethod) && Objects.equals((Object)this.endReason, (Object)other.endReason) && Objects.equals(this.maxParticipants, other.maxParticipants) && Objects.equals(this.uniqueParticipants, other.uniqueParticipants) && Objects.equals(this.uniqueParticipantIdentities, other.uniqueParticipantIdentities) && Objects.equals(this.concurrentParticipants, other.concurrentParticipants) && Objects.equals(this.maxConcurrentParticipants, other.maxConcurrentParticipants) && Objects.equals(this.codecs, other.codecs) && Objects.equals((Object)this.mediaRegion, (Object)other.mediaRegion) && Objects.equals(this.durationSec, other.durationSec) && Objects.equals(this.totalParticipantDurationSec, other.totalParticipantDurationSec) && Objects.equals(this.totalRecordingDurationSec, other.totalRecordingDurationSec) && Objects.equals((Object)this.processingState, (Object)other.processingState) && Objects.equals(this.recordingEnabled, other.recordingEnabled) && Objects.equals((Object)this.edgeLocation, (Object)other.edgeLocation) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.roomSid, this.roomName, this.createTime, this.endTime, this.roomType, this.roomStatus, this.statusCallback, this.statusCallbackMethod, this.createdMethod, this.endReason, this.maxParticipants, this.uniqueParticipants, this.uniqueParticipantIdentities, this.concurrentParticipants, this.maxConcurrentParticipants, this.codecs, this.mediaRegion, this.durationSec, this.totalParticipantDurationSec, this.totalRecordingDurationSec, this.processingState, this.recordingEnabled, this.edgeLocation, this.url, this.links});
    }

    public String toString() {
        return "Room(accountSid=" + this.getAccountSid() + ", roomSid=" + this.getRoomSid() + ", roomName=" + this.getRoomName() + ", createTime=" + this.getCreateTime() + ", endTime=" + this.getEndTime() + ", roomType=" + (Object)((Object)this.getRoomType()) + ", roomStatus=" + (Object)((Object)this.getRoomStatus()) + ", statusCallback=" + this.getStatusCallback() + ", statusCallbackMethod=" + (Object)((Object)this.getStatusCallbackMethod()) + ", createdMethod=" + (Object)((Object)this.getCreatedMethod()) + ", endReason=" + (Object)((Object)this.getEndReason()) + ", maxParticipants=" + this.getMaxParticipants() + ", uniqueParticipants=" + this.getUniqueParticipants() + ", uniqueParticipantIdentities=" + this.getUniqueParticipantIdentities() + ", concurrentParticipants=" + this.getConcurrentParticipants() + ", maxConcurrentParticipants=" + this.getMaxConcurrentParticipants() + ", codecs=" + this.getCodecs() + ", mediaRegion=" + (Object)((Object)this.getMediaRegion()) + ", durationSec=" + this.getDurationSec() + ", totalParticipantDurationSec=" + this.getTotalParticipantDurationSec() + ", totalRecordingDurationSec=" + this.getTotalRecordingDurationSec() + ", processingState=" + (Object)((Object)this.getProcessingState()) + ", recordingEnabled=" + this.getRecordingEnabled() + ", edgeLocation=" + (Object)((Object)this.getEdgeLocation()) + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum EdgeLocation {
        ASHBURN("ashburn"),
        DUBLIN("dublin"),
        FRANKFURT("frankfurt"),
        SINGAPORE("singapore"),
        SYDNEY("sydney"),
        SAO_PAULO("sao_paulo"),
        ROAMING("roaming"),
        UMATILLA("umatilla"),
        TOKYO("tokyo");

        private final String value;

        private EdgeLocation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EdgeLocation forValue(String value) {
            return (EdgeLocation)Promoter.enumFromString((String)value, (Enum[])EdgeLocation.values());
        }
    }

    public static enum CreatedMethod {
        SDK("sdk"),
        AD_HOC("ad_hoc"),
        API("api");

        private final String value;

        private CreatedMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CreatedMethod forValue(String value) {
            return (CreatedMethod)Promoter.enumFromString((String)value, (Enum[])CreatedMethod.values());
        }
    }

    public static enum RoomType {
        GO("go"),
        PEER_TO_PEER("peer_to_peer"),
        GROUP("group"),
        GROUP_SMALL("group_small");

        private final String value;

        private RoomType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoomType forValue(String value) {
            return (RoomType)Promoter.enumFromString((String)value, (Enum[])RoomType.values());
        }
    }

    public static enum RoomStatus {
        IN_PROGRESS("in_progress"),
        COMPLETED("completed");

        private final String value;

        private RoomStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoomStatus forValue(String value) {
            return (RoomStatus)Promoter.enumFromString((String)value, (Enum[])RoomStatus.values());
        }
    }

    public static enum TwilioRealm {
        US1("us1"),
        US2("us2"),
        AU1("au1"),
        BR1("br1"),
        IE1("ie1"),
        JP1("jp1"),
        SG1("sg1"),
        IN1("in1"),
        DE1("de1"),
        GLL("gll");

        private final String value;

        private TwilioRealm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TwilioRealm forValue(String value) {
            return (TwilioRealm)Promoter.enumFromString((String)value, (Enum[])TwilioRealm.values());
        }
    }

    public static enum Codec {
        VP8("VP8"),
        H264("H264"),
        VP9("VP9");

        private final String value;

        private Codec(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Codec forValue(String value) {
            return (Codec)Promoter.enumFromString((String)value, (Enum[])Codec.values());
        }
    }

    public static enum ProcessingState {
        COMPLETE("complete"),
        IN_PROGRESS("in_progress");

        private final String value;

        private ProcessingState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ProcessingState forValue(String value) {
            return (ProcessingState)Promoter.enumFromString((String)value, (Enum[])ProcessingState.values());
        }
    }

    public static enum EndReason {
        ROOM_ENDED_VIA_API("room_ended_via_api"),
        TIMEOUT("timeout");

        private final String value;

        private EndReason(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EndReason forValue(String value) {
            return (EndReason)Promoter.enumFromString((String)value, (Enum[])EndReason.values());
        }
    }
}

