/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.pluginconfiguration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.pluginconfiguration.ConfiguredPluginFetcher;
import com.twilio.rest.flexapi.v1.pluginconfiguration.ConfiguredPluginReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfiguredPlugin
extends Resource {
    private static final long serialVersionUID = 274363191205170L;
    private final String accountSid;
    private final String configurationSid;
    private final String pluginSid;
    private final String pluginVersionSid;
    private final Integer phase;
    private final String pluginUrl;
    private final String uniqueName;
    private final String friendlyName;
    private final String description;
    private final Boolean pluginArchived;
    private final String version;
    private final String changelog;
    private final Boolean pluginVersionArchived;
    private final Boolean _private;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static ConfiguredPluginFetcher fetcher(String pathConfigurationSid, String pathPluginSid) {
        return new ConfiguredPluginFetcher(pathConfigurationSid, pathPluginSid);
    }

    public static ConfiguredPluginReader reader(String pathConfigurationSid) {
        return new ConfiguredPluginReader(pathConfigurationSid);
    }

    public static ConfiguredPlugin fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ConfiguredPlugin.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ConfiguredPlugin fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ConfiguredPlugin.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ConfiguredPlugin(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="configuration_sid") String configurationSid, @JsonProperty(value="plugin_sid") String pluginSid, @JsonProperty(value="plugin_version_sid") String pluginVersionSid, @JsonProperty(value="phase") Integer phase, @JsonProperty(value="plugin_url") String pluginUrl, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="plugin_archived") Boolean pluginArchived, @JsonProperty(value="version") String version, @JsonProperty(value="changelog") String changelog, @JsonProperty(value="plugin_version_archived") Boolean pluginVersionArchived, @JsonProperty(value="_private") Boolean _private, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.configurationSid = configurationSid;
        this.pluginSid = pluginSid;
        this.pluginVersionSid = pluginVersionSid;
        this.phase = phase;
        this.pluginUrl = pluginUrl;
        this.uniqueName = uniqueName;
        this.friendlyName = friendlyName;
        this.description = description;
        this.pluginArchived = pluginArchived;
        this.version = version;
        this.changelog = changelog;
        this.pluginVersionArchived = pluginVersionArchived;
        this._private = _private;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConfigurationSid() {
        return this.configurationSid;
    }

    public final String getPluginSid() {
        return this.pluginSid;
    }

    public final String getPluginVersionSid() {
        return this.pluginVersionSid;
    }

    public final Integer getPhase() {
        return this.phase;
    }

    public final String getPluginUrl() {
        return this.pluginUrl;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Boolean getPluginArchived() {
        return this.pluginArchived;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getChangelog() {
        return this.changelog;
    }

    public final Boolean getPluginVersionArchived() {
        return this.pluginVersionArchived;
    }

    public final Boolean get_private() {
        return this._private;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredPlugin other = (ConfiguredPlugin)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.configurationSid, other.configurationSid) && Objects.equals(this.pluginSid, other.pluginSid) && Objects.equals(this.pluginVersionSid, other.pluginVersionSid) && Objects.equals(this.phase, other.phase) && Objects.equals(this.pluginUrl, other.pluginUrl) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.pluginArchived, other.pluginArchived) && Objects.equals(this.version, other.version) && Objects.equals(this.changelog, other.changelog) && Objects.equals(this.pluginVersionArchived, other.pluginVersionArchived) && Objects.equals(this._private, other._private) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.configurationSid, this.pluginSid, this.pluginVersionSid, this.phase, this.pluginUrl, this.uniqueName, this.friendlyName, this.description, this.pluginArchived, this.version, this.changelog, this.pluginVersionArchived, this._private, this.dateCreated, this.url);
    }

    public String toString() {
        return "ConfiguredPlugin(accountSid=" + this.getAccountSid() + ", configurationSid=" + this.getConfigurationSid() + ", pluginSid=" + this.getPluginSid() + ", pluginVersionSid=" + this.getPluginVersionSid() + ", phase=" + this.getPhase() + ", pluginUrl=" + this.getPluginUrl() + ", uniqueName=" + this.getUniqueName() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", pluginArchived=" + this.getPluginArchived() + ", version=" + this.getVersion() + ", changelog=" + this.getChangelog() + ", pluginVersionArchived=" + this.getPluginVersionArchived() + ", _private=" + this.get_private() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

