/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.plugin;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.plugin.PluginVersions;

public class PluginVersionsFetcher
extends Fetcher<PluginVersions> {
    private String pathPluginSid;
    private String pathSid;
    private String flexMetadata;

    public PluginVersionsFetcher(String pathPluginSid, String pathSid) {
        this.pathPluginSid = pathPluginSid;
        this.pathSid = pathSid;
    }

    public PluginVersionsFetcher setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    @Override
    public PluginVersions fetch(TwilioRestClient client) {
        String path = "/v1/PluginService/Plugins/{PluginSid}/Versions/{Sid}";
        path = path.replace("{PluginSid}", this.pathPluginSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginVersions fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PluginVersions.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

