/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipant;
import java.util.Map;

public class InteractionChannelParticipantCreator
extends Creator<InteractionChannelParticipant> {
    private String pathInteractionSid;
    private String pathChannelSid;
    private InteractionChannelParticipant.Type type;
    private Map<String, Object> mediaProperties;
    private Map<String, Object> routingProperties;

    public InteractionChannelParticipantCreator(String pathInteractionSid, String pathChannelSid, InteractionChannelParticipant.Type type, Map<String, Object> mediaProperties) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.type = type;
        this.mediaProperties = mediaProperties;
    }

    public InteractionChannelParticipantCreator setType(InteractionChannelParticipant.Type type) {
        this.type = type;
        return this;
    }

    public InteractionChannelParticipantCreator setMediaProperties(Map<String, Object> mediaProperties) {
        this.mediaProperties = mediaProperties;
        return this;
    }

    public InteractionChannelParticipantCreator setRoutingProperties(Map<String, Object> routingProperties) {
        this.routingProperties = routingProperties;
        return this;
    }

    @Override
    public InteractionChannelParticipant create(TwilioRestClient client) {
        String path = "/v1/Interactions/{InteractionSid}/Channels/{ChannelSid}/Participants";
        path = path.replace("{InteractionSid}", this.pathInteractionSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Type}", this.type.toString());
        path = path.replace("{MediaProperties}", this.mediaProperties.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InteractionChannelParticipant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InteractionChannelParticipant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.mediaProperties != null) {
            request.addPostParam("MediaProperties", Converter.mapToJson(this.mediaProperties));
        }
        if (this.routingProperties != null) {
            request.addPostParam("RoutingProperties", Converter.mapToJson(this.routingProperties));
        }
    }
}

