/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.interaction.InteractionChannelFetcher;
import com.twilio.rest.flexapi.v1.interaction.InteractionChannelReader;
import com.twilio.rest.flexapi.v1.interaction.InteractionChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InteractionChannel
extends Resource {
    private static final long serialVersionUID = 96183028905472L;
    private final String sid;
    private final String interactionSid;
    private final Type type;
    private final ChannelStatus status;
    private final Integer errorCode;
    private final String errorMessage;
    private final URI url;
    private final Map<String, String> links;

    public static InteractionChannelFetcher fetcher(String pathInteractionSid, String pathSid) {
        return new InteractionChannelFetcher(pathInteractionSid, pathSid);
    }

    public static InteractionChannelReader reader(String pathInteractionSid) {
        return new InteractionChannelReader(pathInteractionSid);
    }

    public static InteractionChannelUpdater updater(String pathInteractionSid, String pathSid, UpdateChannelStatus status) {
        return new InteractionChannelUpdater(pathInteractionSid, pathSid, status);
    }

    public static InteractionChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InteractionChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InteractionChannel(@JsonProperty(value="sid") String sid, @JsonProperty(value="interaction_sid") String interactionSid, @JsonProperty(value="type") Type type, @JsonProperty(value="status") ChannelStatus status, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="error_message") String errorMessage, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.interactionSid = interactionSid;
        this.type = type;
        this.status = status;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getInteractionSid() {
        return this.interactionSid;
    }

    public final Type getType() {
        return this.type;
    }

    public final ChannelStatus getStatus() {
        return this.status;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteractionChannel other = (InteractionChannel)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.interactionSid, other.interactionSid) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.interactionSid, this.type, this.status, this.errorCode, this.errorMessage, this.url, this.links});
    }

    public String toString() {
        return "InteractionChannel(sid=" + this.getSid() + ", interactionSid=" + this.getInteractionSid() + ", type=" + (Object)((Object)this.getType()) + ", status=" + (Object)((Object)this.getStatus()) + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum ChannelStatus {
        SETUP("setup"),
        ACTIVE("active"),
        FAILED("failed"),
        CLOSED("closed"),
        INACTIVE("inactive");

        private final String value;

        private ChannelStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelStatus forValue(String value) {
            return (ChannelStatus)Promoter.enumFromString((String)value, (Enum[])ChannelStatus.values());
        }
    }

    public static enum Type {
        VOICE("voice"),
        SMS("sms"),
        EMAIL("email"),
        WEB("web"),
        WHATSAPP("whatsapp"),
        CHAT("chat"),
        MESSENGER("messenger"),
        GBM("gbm");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }

    public static enum UpdateChannelStatus {
        CLOSED("closed"),
        INACTIVE("inactive");

        private final String value;

        private UpdateChannelStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateChannelStatus forValue(String value) {
            return (UpdateChannelStatus)Promoter.enumFromString((String)value, (Enum[])UpdateChannelStatus.values());
        }
    }
}

