/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.ProvisioningStatusFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProvisioningStatus
extends Resource {
    private static final long serialVersionUID = 116877818354472L;
    private final Status status;
    private final URI url;

    public static ProvisioningStatusFetcher fetcher() {
        return new ProvisioningStatusFetcher();
    }

    public static ProvisioningStatus fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ProvisioningStatus.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ProvisioningStatus fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ProvisioningStatus.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ProvisioningStatus(@JsonProperty(value="status") Status status, @JsonProperty(value="url") URI url) {
        this.status = status;
        this.url = url;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvisioningStatus other = (ProvisioningStatus)o;
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.url});
    }

    public String toString() {
        return "ProvisioningStatus(status=" + (Object)((Object)this.getStatus()) + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        ACTIVE("active"),
        IN_PROGRESS("in-progress"),
        NOT_CONFIGURED("not-configured"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

