/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.PluginReleaseCreator;
import com.twilio.rest.flexapi.v1.PluginReleaseFetcher;
import com.twilio.rest.flexapi.v1.PluginReleaseReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginRelease
extends Resource {
    private static final long serialVersionUID = 6792045414097L;
    private final String sid;
    private final String accountSid;
    private final String configurationSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static PluginReleaseCreator creator(String configurationId) {
        return new PluginReleaseCreator(configurationId);
    }

    public static PluginReleaseFetcher fetcher(String pathSid) {
        return new PluginReleaseFetcher(pathSid);
    }

    public static PluginReleaseReader reader() {
        return new PluginReleaseReader();
    }

    public static PluginRelease fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginRelease.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PluginRelease fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginRelease.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PluginRelease(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="configuration_sid") String configurationSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.configurationSid = configurationSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConfigurationSid() {
        return this.configurationSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginRelease other = (PluginRelease)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.configurationSid, other.configurationSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.configurationSid, this.dateCreated, this.url);
    }

    public String toString() {
        return "PluginRelease(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", configurationSid=" + this.getConfigurationSid() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

